/*
 * Decompiled with CFR 0.152.
 */
package org.leandreck.endpoints.processor.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.leandreck.endpoints.processor.model.EnumValue;
import org.leandreck.endpoints.processor.model.TypeNodeKind;

public class TypeNode {
    private final String fieldName;
    private final String typeName;
    private final String type;
    private final String template;
    private final boolean mappedType;
    private final TypeNodeKind kind;
    private final List<TypeNode> typeParameters;
    private final List<TypeNode> children;
    private final Set<TypeNode> types;
    private final Set<EnumValue> enumValues;
    private final boolean isDeclaredComplexType;

    public TypeNode(String fieldName, String typeName, TypeNodeKind kind) {
        this.fieldName = fieldName;
        this.typeName = typeName;
        this.kind = kind;
        this.typeParameters = Collections.emptyList();
        this.template = "";
        this.children = Collections.emptyList();
        this.mappedType = true;
        this.type = this.defineType();
        this.types = this.collectTypes();
        this.isDeclaredComplexType = false;
        this.enumValues = Collections.emptySet();
    }

    public TypeNode(String fieldName, String typeName, List<TypeNode> typeParameters, String template, TypeNodeKind kind, List<TypeNode> children, Set<EnumValue> enumValues) {
        this.fieldName = fieldName;
        this.typeName = typeName;
        this.typeParameters = typeParameters;
        this.template = template;
        this.kind = kind;
        this.children = children;
        this.enumValues = enumValues;
        this.mappedType = false;
        this.type = this.defineType();
        this.types = this.collectTypes();
        this.isDeclaredComplexType = this.defineIsDeclaredComplexType();
    }

    private boolean defineIsDeclaredComplexType() {
        boolean isDeclared = !this.isMappedType() && !TypeNodeKind.MAP.equals((Object)this.getKind());
        return isDeclared;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    private String defineType() {
        String name;
        switch (this.kind) {
            case ARRAY: 
            case COLLECTION: {
                name = this.typeName + "[]";
                break;
            }
            case MAP: {
                name = "{ [index: " + this.typeParameters.get((int)0).type + "]: " + this.typeParameters.get((int)1).type + " }";
                break;
            }
            default: {
                name = this.typeName;
            }
        }
        return name;
    }

    private Set<TypeNode> collectTypes() {
        HashMap typeMap = new HashMap();
        this.children.stream().filter(c -> !c.isMappedType()).forEach(t -> TypeNode.mapType(t, typeMap));
        this.typeParameters.stream().filter(c -> !c.isMappedType()).forEach(t -> typeMap.put(t.getTypeName(), t));
        return new HashSet<TypeNode>(typeMap.values());
    }

    private static void mapType(TypeNode type, Map<String, TypeNode> typeMap) {
        if (TypeNodeKind.MAP.equals((Object)type.getKind())) {
            type.getTypeParameters().stream().filter(c -> !c.isMappedType()).forEach(t -> typeMap.put(t.getTypeName(), (TypeNode)t));
        } else {
            typeMap.put(type.getTypeName(), type);
        }
    }

    public String getTemplate() {
        return this.template;
    }

    public List<TypeNode> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public TypeNodeKind getKind() {
        return this.kind;
    }

    public String getType() {
        return this.type;
    }

    public boolean isMappedType() {
        return this.mappedType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeNode typeNode = (TypeNode)o;
        return this.typeName.equals(typeNode.typeName);
    }

    public int hashCode() {
        return this.typeName.hashCode();
    }

    public List<TypeNode> getTypeParameters() {
        return this.typeParameters;
    }

    public Set<TypeNode> getTypes() {
        return this.types;
    }

    public boolean isDeclaredComplexType() {
        return this.isDeclaredComplexType;
    }

    public Set<EnumValue> getEnumValues() {
        return this.enumValues;
    }
}

