/*
 * Decompiled with CFR 0.152.
 */
package org.leandreck.endpoints.processor.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import org.leandreck.endpoints.processor.model.RequestMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public class RequestMappingFactory {
    public RequestMapping createRequestMapping(ExecutableElement methodElement) {
        ArrayList<RequestMethod> methods = new ArrayList<RequestMethod>();
        ArrayList<String> produces = new ArrayList<String>();
        ArrayList<String> value = new ArrayList<String>();
        this.populate(methods, produces, value, (Annotation)methodElement.getAnnotation(org.springframework.web.bind.annotation.RequestMapping.class), null);
        this.populate(methods, produces, value, (Annotation)methodElement.getAnnotation(GetMapping.class), RequestMethod.GET);
        this.populate(methods, produces, value, (Annotation)methodElement.getAnnotation(PostMapping.class), RequestMethod.POST);
        this.populate(methods, produces, value, (Annotation)methodElement.getAnnotation(PutMapping.class), RequestMethod.PUT);
        this.populate(methods, produces, value, (Annotation)methodElement.getAnnotation(DeleteMapping.class), RequestMethod.DELETE);
        this.populate(methods, produces, value, (Annotation)methodElement.getAnnotation(PatchMapping.class), RequestMethod.PATCH);
        return new RequestMapping(methods.toArray(new RequestMethod[0]), produces.toArray(new String[0]), value.toArray(new String[0]));
    }

    public void populate(List<RequestMethod> methods, List<String> produces, List<String> value, Annotation annotation, RequestMethod requestMethod) {
        if (annotation != null) {
            if (annotation instanceof org.springframework.web.bind.annotation.RequestMapping) {
                org.springframework.web.bind.annotation.RequestMapping requestMapping = (org.springframework.web.bind.annotation.RequestMapping)annotation;
                RequestMethod[] methods2Add = requestMapping.method();
                if (methods2Add.length == 0) {
                    methods.add(RequestMethod.GET);
                } else {
                    methods.addAll(Arrays.asList(requestMapping.method()));
                }
            }
            if (requestMethod != null) {
                methods.add(requestMethod);
            }
            produces.addAll(Arrays.asList(this.invokeMethod(annotation, "produces")));
            value.addAll(Arrays.asList(this.invokeMethod(annotation, "value")));
        }
    }

    private String[] invokeMethod(Annotation annotation, String methodName) {
        try {
            Method method = annotation.getClass().getMethod(methodName, new Class[0]);
            return (String[])method.invoke((Object)annotation, new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            return new String[0];
        }
    }
}

