/*
 * Decompiled with CFR 0.152.
 */
package org.leandreck.endpoints.processor.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.leandreck.endpoints.annotations.TypeScriptIgnore;
import org.leandreck.endpoints.annotations.TypeScriptType;
import org.leandreck.endpoints.processor.model.TypeNode;
import org.leandreck.endpoints.processor.model.TypeNodeKind;

class TypeNodeFactory {
    private static final Map<String, String> mappings = new HashMap<String, String>(20);
    private static final String NUMBER_TYPE = "Number";
    private static final String STRING_TYPE = "String";
    private static final String BOOLEAN_TYPE = "Boolean";
    private final Types typeUtils;
    private final Elements elementUtils;
    private final Map<String, List<TypeNode>> createdChildren = new ConcurrentHashMap<String, List<TypeNode>>(200);

    public TypeNodeFactory(Types typeUtils, Elements elementUtils) {
        this.typeUtils = typeUtils;
        this.elementUtils = elementUtils;
    }

    public TypeNode createTypeNode(VariableElement variableElement) {
        TypeScriptType typeScriptTypeAnnotation = variableElement.getAnnotation(TypeScriptType.class);
        TypeMirror typeMirror = variableElement.asType();
        TypeNodeKind typeNodeKind = this.defineKind(typeMirror);
        String typeName = this.defineName(typeMirror, typeNodeKind, typeScriptTypeAnnotation);
        String fieldName = variableElement.getSimpleName().toString();
        List<TypeNode> children = this.createdChildren.get(typeName);
        if (children != null) {
            return this.initType(fieldName, typeNodeKind, typeName, typeMirror, typeScriptTypeAnnotation, children);
        }
        return this.initType(fieldName, typeNodeKind, typeName, typeMirror, typeScriptTypeAnnotation);
    }

    public TypeNode createTypeNode(TypeMirror typeMirror) {
        Element definingElement = this.typeUtils.asElement(typeMirror);
        TypeScriptType typeScriptTypeAnnotation = definingElement != null ? definingElement.getAnnotation(TypeScriptType.class) : null;
        TypeNodeKind typeNodeKind = this.defineKind(typeMirror);
        String typeName = this.defineName(typeMirror, typeNodeKind);
        String fieldName = "TYPE-ROOT";
        List<TypeNode> children = this.createdChildren.get(typeName);
        if (children != null) {
            return this.initType("TYPE-ROOT", typeNodeKind, typeName, typeMirror, typeScriptTypeAnnotation, children);
        }
        return this.initType("TYPE-ROOT", typeNodeKind, typeName, typeMirror, typeScriptTypeAnnotation);
    }

    private TypeNode initType(String fieldName, TypeNodeKind typeNodeKind, String typeName, TypeMirror typeMirror, TypeScriptType typeScriptTypeAnnotation) {
        TypeNode newTypeNode;
        if (mappings.containsValue(typeName)) {
            newTypeNode = new TypeNode(fieldName, typeName, typeNodeKind);
        } else {
            TypeElement typeElement = (TypeElement)this.typeUtils.asElement(typeMirror);
            String template = TypeNodeFactory.defineTemplate(typeScriptTypeAnnotation);
            List<String> publicGetter = this.definePublicGetter(typeElement);
            List<TypeNode> children = this.defineChildren(typeElement, publicGetter);
            newTypeNode = new TypeNode(fieldName, typeName, template, typeNodeKind, children);
            this.createdChildren.put(typeName, children);
        }
        return newTypeNode;
    }

    private TypeNode initType(String fieldName, TypeNodeKind typeNodeKind, String typeName, TypeMirror typeMirror, TypeScriptType typeScriptTypeAnnotation, List<TypeNode> children) {
        String template = TypeNodeFactory.defineTemplate(typeScriptTypeAnnotation);
        return new TypeNode(fieldName, typeName, template, typeNodeKind, children);
    }

    private List<String> definePublicGetter(TypeElement typeElement) {
        return ElementFilter.methodsIn(typeElement.getEnclosedElements()).stream().filter(g -> g.getSimpleName().toString().startsWith("get") || g.getSimpleName().toString().startsWith("is")).filter(g -> g.getModifiers().contains((Object)Modifier.PUBLIC)).filter(g -> !g.getModifiers().contains((Object)Modifier.ABSTRACT)).map(g -> g.getSimpleName().toString()).collect(Collectors.toList());
    }

    private boolean filterVariableElements(VariableElement variableElement, List<String> publicGetter) {
        return publicGetter.stream().map(g -> g.toLowerCase().endsWith(variableElement.getSimpleName().toString().toLowerCase())).reduce(false, (a, b) -> a != false || b != false);
    }

    private List<TypeNode> defineChildren(TypeElement typeElement, List<String> publicGetter) {
        return ElementFilter.fieldsIn(typeElement.getEnclosedElements()).stream().filter(c -> c.getAnnotation(TypeScriptIgnore.class) == null).filter(c -> !c.getModifiers().contains((Object)Modifier.TRANSIENT)).filter(c -> this.filterVariableElements((VariableElement)c, publicGetter)).map(this::createTypeNode).collect(Collectors.toList());
    }

    private static String defineTemplate(TypeScriptType typeScriptTypeAnnotation) {
        String template = typeScriptTypeAnnotation == null || typeScriptTypeAnnotation.template().isEmpty() ? "/org/leandreck/endpoints/templates/typescript/interface.ftl" : typeScriptTypeAnnotation.template();
        return template;
    }

    private String defineName(TypeMirror typeMirror, TypeNodeKind typeNodeKind, TypeScriptType typeScriptTypeAnnotation) {
        String typeFromAnnotation;
        if (typeScriptTypeAnnotation != null && !"UNDEFINED".equals(typeFromAnnotation = this.defineTypeFromAnnotation(typeScriptTypeAnnotation))) {
            return typeFromAnnotation;
        }
        return this.defineName(typeMirror, typeNodeKind);
    }

    private String defineName(TypeMirror typeMirror, TypeNodeKind typeNodeKind) {
        String name;
        switch (typeNodeKind) {
            case ARRAY: {
                name = this.defineNameFromArrayType((ArrayType)typeMirror);
                break;
            }
            case COLLECTION: {
                name = this.defineNameFromCollectionType((DeclaredType)typeMirror);
                break;
            }
            case MAP: {
                name = this.defineNameFromMapType((DeclaredType)typeMirror);
                break;
            }
            default: {
                name = this.defineNameFromSimpleType(typeMirror);
            }
        }
        return name;
    }

    private String defineTypeFromAnnotation(TypeScriptType annotation) {
        if (annotation != null && !annotation.value().isEmpty()) {
            return annotation.value();
        }
        return "UNDEFINED";
    }

    private String defineNameFromSimpleType(TypeMirror typeMirror) {
        String key;
        String mappedValue;
        TypeKind kind = typeMirror.getKind();
        String typeName = kind.isPrimitive() || TypeKind.VOID.equals((Object)kind) ? mappings.get(kind.name()) : (TypeKind.DECLARED.equals((Object)kind) ? ((mappedValue = mappings.get(key = this.typeUtils.asElement(typeMirror).getSimpleName().toString())) == null ? "I" + key : mappedValue) : "UNDEFINED");
        return typeName;
    }

    private String defineNameFromArrayType(ArrayType arrayMirror) {
        TypeMirror componentMirror = arrayMirror.getComponentType();
        return this.defineNameFromSimpleType(componentMirror);
    }

    private String defineNameFromCollectionType(DeclaredType declaredType) {
        TypeMirror genericMirror;
        List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
        TypeElement listElement = typeArguments.isEmpty() ? this.elementUtils.getTypeElement("java.lang.Object") : (TypeKind.WILDCARD.equals((Object)(genericMirror = typeArguments.get(0)).getKind()) ? this.elementUtils.getTypeElement("java.lang.Object") : (TypeElement)this.typeUtils.asElement(genericMirror));
        return this.defineNameFromSimpleType(listElement.asType());
    }

    private String defineNameFromMapType(DeclaredType declaredType) {
        TypeElement valueElement;
        TypeElement keyElement;
        List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
        if (typeArguments.isEmpty()) {
            keyElement = this.elementUtils.getTypeElement("java.lang.Object");
            valueElement = this.elementUtils.getTypeElement("java.lang.Object");
        } else {
            TypeMirror keyMirror = typeArguments.get(0);
            keyElement = TypeKind.WILDCARD.equals((Object)keyMirror.getKind()) ? this.elementUtils.getTypeElement("java.lang.Object") : (TypeElement)this.typeUtils.asElement(keyMirror);
            TypeMirror valueMirror = typeArguments.get(1);
            valueElement = TypeKind.WILDCARD.equals((Object)valueMirror.getKind()) ? this.elementUtils.getTypeElement("java.lang.Object") : (TypeElement)this.typeUtils.asElement(valueMirror);
        }
        String keyName = this.defineNameFromSimpleType(keyElement.asType());
        String valueName = this.defineNameFromSimpleType(valueElement.asType());
        return keyName + "/" + valueName;
    }

    private TypeNodeKind defineKind(TypeMirror typeMirror) {
        TypeNodeKind typeNodeKind;
        TypeKind kind = typeMirror.getKind();
        switch (kind) {
            case ARRAY: {
                typeNodeKind = TypeNodeKind.ARRAY;
                break;
            }
            case DECLARED: {
                TypeMirror collectionMirror = this.elementUtils.getTypeElement("java.util.Collection").asType();
                DeclaredType mapMirror = this.typeUtils.getDeclaredType(this.elementUtils.getTypeElement("java.util.Map"), new TypeMirror[0]);
                if (this.typeUtils.isAssignable(typeMirror, this.typeUtils.erasure(collectionMirror))) {
                    typeNodeKind = TypeNodeKind.COLLECTION;
                    break;
                }
                if (this.typeUtils.isAssignable(typeMirror, this.typeUtils.erasure(mapMirror))) {
                    typeNodeKind = TypeNodeKind.MAP;
                    break;
                }
                typeNodeKind = TypeNodeKind.SIMPLE;
                break;
            }
            default: {
                typeNodeKind = TypeNodeKind.SIMPLE;
            }
        }
        return typeNodeKind;
    }

    static {
        mappings.put("VOID", "Void");
        mappings.put("BYTE", NUMBER_TYPE);
        mappings.put("Byte", NUMBER_TYPE);
        mappings.put("SHORT", NUMBER_TYPE);
        mappings.put("Short", NUMBER_TYPE);
        mappings.put("INT", NUMBER_TYPE);
        mappings.put("Integer", NUMBER_TYPE);
        mappings.put("LONG", NUMBER_TYPE);
        mappings.put("Long", NUMBER_TYPE);
        mappings.put("FLOAT", NUMBER_TYPE);
        mappings.put("Float", NUMBER_TYPE);
        mappings.put("DOUBLE", NUMBER_TYPE);
        mappings.put("Double", NUMBER_TYPE);
        mappings.put("BigDecimal", NUMBER_TYPE);
        mappings.put("BigInteger", NUMBER_TYPE);
        mappings.put("CHAR", STRING_TYPE);
        mappings.put("Character", STRING_TYPE);
        mappings.put(STRING_TYPE, STRING_TYPE);
        mappings.put("BOOLEAN", BOOLEAN_TYPE);
        mappings.put(BOOLEAN_TYPE, BOOLEAN_TYPE);
        mappings.put("Date", "Date");
        mappings.put("LocalDate", "Date");
        mappings.put("Object", "any");
    }
}

