/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.jsonp.testsuite.tests;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.leadpony.jsonp.testsuite.helper.JsonAssertions;
import org.leadpony.jsonp.testsuite.tests.JsonResource;
import org.leadpony.jsonp.testsuite.tests.JsonValueTestCase;

public class JsonWriterTest {
    private static JsonWriterFactory factory;

    @BeforeAll
    public static void setUpOnce() {
        factory = Json.createWriterFactory(null);
    }

    @ParameterizedTest
    @EnumSource(value=JsonValueTestCase.class)
    public void writeShouldWriteJsonValueAsExpected(JsonValueTestCase test) {
        String actual = JsonWriterTest.write(writer -> writer.write(test.getJsonValue()));
        JsonAssertions.assertThat(actual).isEqualTo(test.getString());
    }

    @ParameterizedTest
    @EnumSource(value=JsonResource.class)
    public void writeShouldWriteJsonValueAsExpected(JsonResource test) {
        JsonValue value = JsonWriterTest.readValueFrom(test);
        String actual = JsonWriterTest.write(writer -> writer.write(value));
        Assertions.assertThat((String)actual).isEqualTo(test.getMinifiedJsonAsString());
    }

    public static Stream<JsonValueTestCase> writeShouldWriteJsonStructureAsExpected() {
        return JsonValueTestCase.getStructuresAsStream();
    }

    @ParameterizedTest
    @MethodSource
    public void writeShouldWriteJsonStructureAsExpected(JsonValueTestCase test) {
        String actual = JsonWriterTest.write(writer -> writer.write((JsonStructure)test.getJsonValue()));
        Assertions.assertThat((String)actual).isEqualTo(test.getString());
    }

    public static Stream<JsonValueTestCase> writeArrayShouldWriteJsonArrayAsExpected() {
        return JsonValueTestCase.getArraysAsStream();
    }

    @ParameterizedTest
    @MethodSource
    public void writeArrayShouldWriteJsonArrayAsExpected(JsonValueTestCase test) {
        String actual = JsonWriterTest.write(writer -> writer.writeArray((JsonArray)test.getJsonValue()));
        Assertions.assertThat((String)actual).isEqualTo(test.getString());
    }

    public static Stream<JsonValueTestCase> writeObjectShouldWriteJsonObjectAsExpected() {
        return JsonValueTestCase.getObjectsAsStream();
    }

    @ParameterizedTest
    @MethodSource
    public void writeObjectShouldWriteJsonObjectAsExpected(JsonValueTestCase test) {
        String actual = JsonWriterTest.write(writer -> writer.writeObject((JsonObject)test.getJsonValue()));
        Assertions.assertThat((String)actual).isEqualTo(test.getString());
    }

    private static String write(Consumer<JsonWriter> consumer) {
        StringWriter stringWriter = new StringWriter();
        try (JsonWriter jsonWriter = factory.createWriter((Writer)stringWriter);){
            consumer.accept(jsonWriter);
        }
        return stringWriter.toString();
    }

    private static JsonValue readValueFrom(JsonResource resource) {
        try (JsonReader reader = Json.createReader((InputStream)resource.openStream());){
            JsonValue jsonValue = reader.readValue();
            return jsonValue;
        }
    }
}

