/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.jsonp.testsuite.tests;

import jakarta.json.Json;
import jakarta.json.JsonWriterFactory;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class JsonWriterFactoryTest {
    @Test
    public void getConfigInUseShouldReturnEmptyMap() {
        HashMap config = new HashMap();
        JsonWriterFactory factory = Json.createWriterFactory(config);
        Map actual = factory.getConfigInUse();
        Assertions.assertThat((Map)actual).isEmpty();
    }

    @Test
    public void getConfigInUseShouldReturnPrettyPrinting() {
        HashMap<String, Boolean> config = new HashMap<String, Boolean>();
        config.put("jakarta.json.stream.JsonGenerator.prettyPrinting", Boolean.FALSE);
        JsonWriterFactory factory = Json.createWriterFactory(config);
        Map actual = factory.getConfigInUse();
        Assertions.assertThat((Map)actual).containsKey((Object)"jakarta.json.stream.JsonGenerator.prettyPrinting");
    }

    @Test
    public void getConfigInUseShouldNotContainUnknownProperty() {
        HashMap<String, Boolean> config = new HashMap<String, Boolean>();
        config.put("unknown", Boolean.TRUE);
        JsonWriterFactory factory = Json.createWriterFactory(config);
        Map actual = factory.getConfigInUse();
        Assertions.assertThat((Map)actual).doesNotContainKey((Object)"unknown");
    }
}

