/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.jsonp.testsuite.tests;

import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonMergePatch;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.spi.JsonProvider;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.leadpony.jsonp.testsuite.helper.LoggerFactory;
import org.leadpony.jsonp.testsuite.tests.JsonValueTestCase;
import org.leadpony.jsonp.testsuite.tests.TestCaseResource;

public class JsonProviderTest {
    private static final Logger LOG = LoggerFactory.getLogger(JsonProviderTest.class);
    private static JsonProvider provider;

    @BeforeAll
    public static void setUpOnces() {
        provider = JsonProvider.provider();
    }

    @Test
    public void createArrayBuilderShouldReturnEmptyBuilder() {
        JsonArrayBuilder builder = provider.createArrayBuilder();
        JsonArray result = builder.build();
        Assertions.assertThat((List)result).isEqualTo((Object)JsonValue.EMPTY_JSON_ARRAY);
    }

    public static Stream<JsonValueTestCase> createArrayBuilderShouldReturnBuilderFilledWithArray() {
        return JsonValueTestCase.getArraysAsStream();
    }

    @ParameterizedTest
    @MethodSource
    public void createArrayBuilderShouldReturnBuilderFilledWithArray(JsonValueTestCase test) {
        JsonArray array = (JsonArray)test.getJsonValue();
        JsonArrayBuilder builder = provider.createArrayBuilder(array);
        JsonArray result = builder.build();
        Assertions.assertThat((List)result).isEqualTo((Object)array);
    }

    @ParameterizedTest
    @EnumSource(value=CollectionBasedArrayBuilderTestCase.class)
    public void createArrayBuilderShouldReturnBuilderFilledWithCollection(CollectionBasedArrayBuilderTestCase test) {
        Assertions.assertThatCode(() -> {
            JsonArrayBuilder builder = provider.createArrayBuilder(test.collection);
            JsonArray result = builder.build();
            Assertions.assertThat((String)result.toString()).isEqualTo(test.string);
        }).doesNotThrowAnyException();
    }

    public static Stream<Object> illegalValuesAsJsonValue() {
        return Stream.of(Paths.get(".", new String[0]), LocalDateTime.now(), StandardCharsets.UTF_8);
    }

    @ParameterizedTest
    @MethodSource(value={"illegalValuesAsJsonValue"})
    public void createArrayBuilderShouldThrowException(Object value) {
        ArrayList<Object> collection = new ArrayList<Object>();
        collection.add(value);
        Throwable thrown = Assertions.catchThrowable(() -> provider.createArrayBuilder((Collection)collection));
        Assertions.assertThat((Throwable)thrown).isInstanceOf(IllegalArgumentException.class);
        LOG.info(thrown.getMessage());
    }

    @Test
    public void createObjectBuilderShouldReturnEmptyBuilder() {
        JsonObjectBuilder builder = provider.createObjectBuilder();
        JsonObject result = builder.build();
        Assertions.assertThat((Map)result).isEqualTo((Object)JsonValue.EMPTY_JSON_OBJECT);
    }

    public static Stream<JsonValueTestCase> createObjectBuilderShouldReturnBuilderFilledWithObject() {
        return JsonValueTestCase.getObjectsAsStream();
    }

    @ParameterizedTest
    @MethodSource
    public void createObjectBuilderShouldReturnBuilderFilledWithObject(JsonValueTestCase test) {
        JsonObject object = (JsonObject)test.getJsonValue();
        JsonObjectBuilder builder = provider.createObjectBuilder(object);
        JsonObject result = builder.build();
        Assertions.assertThat((Map)result).isEqualTo((Object)object);
    }

    @ParameterizedTest
    @EnumSource(value=MapBasedObjectBuilderTestCase.class)
    public void createObjectBuilderShouldReturnBuilderFilledWithMap(MapBasedObjectBuilderTestCase test) {
        Assertions.assertThatCode(() -> {
            JsonObjectBuilder builder = provider.createObjectBuilder(test.map);
            JsonObject result = builder.build();
            Assertions.assertThat((String)result.toString()).isEqualTo(test.string);
        }).doesNotThrowAnyException();
    }

    @ParameterizedTest
    @MethodSource(value={"illegalValuesAsJsonValue"})
    public void createObjectBuilderShouldThrowException(Object value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("a", value);
        Throwable thrown = Assertions.catchThrowable(() -> provider.createObjectBuilder(map));
        Assertions.assertThat((Throwable)thrown).isInstanceOf(IllegalArgumentException.class);
        LOG.info(thrown.getMessage());
    }

    public static Stream<DiffMergeTestCase> createMergeDiffShouldReturnMergePatchAsExpected() {
        return Stream.of(TestCaseResource.RFC7396_EXAMPLES, TestCaseResource.JSON_MERGE_DIFF).flatMap(TestCaseResource::getObjectStream).flatMap(object -> {
            JsonValue original = (JsonValue)object.get((Object)"source");
            return object.getJsonArray("tests").stream().map(JsonValue::asJsonObject).map(test -> new DiffMergeTestCase(test.getString("description"), original, (JsonValue)test.get((Object)"patch"), (JsonValue)test.get((Object)"target")));
        });
    }

    @ParameterizedTest
    @MethodSource
    public void createMergeDiffShouldReturnMergePatchAsExpected(DiffMergeTestCase test) {
        JsonMergePatch patch = provider.createMergeDiff(test.source, test.target);
        Assertions.assertThat((Object)patch.toJsonValue()).isEqualTo((Object)test.patch);
    }

    private static List<Object> collection(Consumer<List<Object>> consumer) {
        ArrayList<Object> list = new ArrayList<Object>();
        consumer.accept(list);
        return list;
    }

    private static Map<String, Object> map(Consumer<Map<String, Object>> consumer) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        consumer.accept(map);
        return map;
    }

    static class DiffMergeTestCase {
        final String description;
        final JsonValue source;
        final JsonValue patch;
        final JsonValue target;

        DiffMergeTestCase(String description, JsonValue source, JsonValue patch, JsonValue target) {
            this.description = description;
            this.source = source;
            this.patch = patch;
            this.target = target;
        }

        public String toString() {
            return this.description;
        }
    }

    static enum MapBasedObjectBuilderTestCase {
        SIMPLE(JsonProviderTest.access$100(m -> {
            m.put("a", "hello");
            m.put("b", 42);
            m.put("c", 3.14);
            m.put("d", true);
            m.put("e", false);
        }), "{\"a\":\"hello\",\"b\":42,\"c\":3.14,\"d\":true,\"e\":false}"),
        NULL(JsonProviderTest.access$100(m -> m.put("a", null)), "{\"a\":null}"),
        ARRAY(JsonProviderTest.access$100(m -> {
            m.put("a", JsonProviderTest.collection(c -> {
                c.add("hello");
                c.add(42);
            }));
            m.put("b", JsonProviderTest.collection(c -> {
                c.add(3.14);
                c.add(true);
            }));
        }), "{\"a\":[\"hello\",42],\"b\":[3.14,true]}"),
        OBJECT(JsonProviderTest.access$100(m -> {
            m.put("a", JsonProviderTest.map(m2 -> {
                m2.put("b", "hello");
                m2.put("c", 42);
            }));
            m.put("d", JsonProviderTest.map(m2 -> {
                m2.put("e", 3.14);
                m2.put("f", true);
            }));
        }), "{\"a\":{\"b\":\"hello\",\"c\":42},\"d\":{\"e\":3.14,\"f\":true}}"),
        OPTIONAL(JsonProviderTest.access$100(m -> {
            m.put("a", Optional.of("hello"));
            m.put("b", Optional.empty());
            m.put("c", Optional.of(3.14));
            m.put("d", Optional.of(true));
            m.put("e", Optional.empty());
        }), "{\"a\":\"hello\",\"c\":3.14,\"d\":true}");

        final Map<String, Object> map;
        final String string;

        private MapBasedObjectBuilderTestCase(Map<String, Object> map, String string2) {
            this.map = map;
            this.string = string2;
        }
    }

    static enum CollectionBasedArrayBuilderTestCase {
        SIMPLE(JsonProviderTest.access$000(c -> {
            c.add("hello");
            c.add(42);
            c.add(3.14);
            c.add(true);
            c.add(false);
        }), "[\"hello\",42,3.14,true,false]"),
        NULL(JsonProviderTest.access$000(c -> c.add(null)), "[null]"),
        ARRAY(JsonProviderTest.access$000(c -> {
            c.add(JsonProviderTest.collection(c2 -> {
                c2.add("hello");
                c2.add(42);
            }));
            c.add(JsonProviderTest.collection(c2 -> {
                c2.add(3.14);
                c2.add(true);
            }));
        }), "[[\"hello\",42],[3.14,true]]"),
        OBJECT(JsonProviderTest.access$000(c -> {
            c.add(JsonProviderTest.map(m -> {
                m.put("a", "hello");
                m.put("b", 42);
            }));
            c.add(JsonProviderTest.map(m -> {
                m.put("c", 3.14);
                m.put("d", true);
            }));
        }), "[{\"a\":\"hello\",\"b\":42},{\"c\":3.14,\"d\":true}]"),
        OPTIONAL(JsonProviderTest.access$000(c -> {
            c.add(Optional.of("hello"));
            c.add(Optional.empty());
            c.add(Optional.of(3.14));
            c.add(Optional.of(true));
            c.add(Optional.empty());
        }), "[\"hello\",3.14,true]");

        final Collection<Object> collection;
        final String string;

        private CollectionBasedArrayBuilderTestCase(List<Object> collection, String string2) {
            this.collection = collection;
            this.string = string2;
        }
    }
}

