/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.jsonp.testsuite.tests;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonPatch;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.util.List;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.leadpony.jsonp.testsuite.tests.TestCaseResource;

public class JsonPatchDiffTest {
    @Test
    public void createDiffShouldCreateEmptyPatchIfStructureIsSame() {
        JsonObject source;
        JsonObject target = source = JsonValue.EMPTY_JSON_OBJECT;
        JsonPatch actual = Json.createDiff((JsonStructure)source, (JsonStructure)target);
        Assertions.assertThat((List)actual.toJsonArray()).isEqualTo((Object)JsonValue.EMPTY_JSON_ARRAY);
    }

    public static Stream<DiffTestCase> createDiffShouldCreatePatchAsExpected() {
        return TestCaseResource.JSON_PATCH_DIFF.getObjectStream().map(object -> new DiffTestCase(object.getString("description"), (JsonStructure)object.get((Object)"source"), (JsonStructure)object.get((Object)"target"), object.getJsonArray("patch")));
    }

    @ParameterizedTest
    @MethodSource
    public void createDiffShouldCreatePatchAsExpected(DiffTestCase test) {
        JsonPatch actual = Json.createDiff((JsonStructure)test.source, (JsonStructure)test.target);
        Assertions.assertThatCode(() -> {
            JsonStructure result = actual.apply(test.source);
            Assertions.assertThat((Object)result).isEqualTo((Object)test.target);
        }).doesNotThrowAnyException();
        if (test.patch != null) {
            Assertions.assertThat((List)actual.toJsonArray()).isEqualTo((Object)test.patch);
        }
    }

    public static final class DiffTestCase {
        private final String description;
        final JsonStructure source;
        final JsonStructure target;
        final JsonArray patch;

        DiffTestCase(String description, JsonStructure source, JsonStructure target, JsonArray patch) {
            this.description = description;
            this.source = source;
            this.target = target;
            this.patch = patch;
        }

        public String toString() {
            return this.description;
        }
    }
}

