/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.jsonp.testsuite.tests;

import jakarta.json.Json;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParserFactory;
import java.io.Reader;
import java.io.StringReader;
import java.time.Duration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class JsonParserSkipTest {
    private static JsonParserFactory parserFactory;

    @BeforeAll
    public static void setUpOnce() {
        parserFactory = Json.createParserFactory(null);
    }

    @Test
    public void skipArrayShouldNotLoopForeverEvenIfNotClosed() {
        String json = "[1,2,3";
        JsonParser parser = this.createJsonParser(json);
        parser.next();
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(500L), () -> {
            try {
                parser.skipArray();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    @Test
    public void skipObjectShouldNotLoopForeverEvenIfNotClosed() {
        String json = "{\"a\":1";
        JsonParser parser = this.createJsonParser(json);
        parser.next();
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(500L), () -> {
            try {
                parser.skipObject();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private JsonParser createJsonParser(String json) {
        return parserFactory.createParser((Reader)new StringReader(json));
    }
}

