/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.jsonp.testsuite.tests;

import jakarta.json.Json;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParserFactory;
import java.io.Reader;
import java.io.StringReader;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.leadpony.jsonp.testsuite.helper.JsonSupplier;
import org.leadpony.jsonp.testsuite.helper.LoggerFactory;

public class JsonParserIllegalStateTest {
    private static final Logger LOG = LoggerFactory.getLogger(JsonParserIllegalStateTest.class);
    private static JsonParserFactory parserFactory;

    @BeforeAll
    public static void setUpOnce() {
        parserFactory = Json.createParserFactory(null);
    }

    @ParameterizedTest
    @EnumSource(value=IllegalStringRetrievalTestCase.class)
    public void getStringShouldThrowIllegalStateException(IllegalStringRetrievalTestCase test) {
        Throwable thrown = this.doIllegalCall(test.getJson(), test.iterations, JsonParser::getString);
        Assertions.assertThat((Throwable)thrown).isInstanceOf(IllegalStateException.class);
        LOG.info(thrown.getMessage());
    }

    @ParameterizedTest
    @EnumSource(value=IllegalNumberRetrievalTestCase.class)
    public void getBigDecimalShouldThrowIllegalStateException(IllegalNumberRetrievalTestCase test) {
        Throwable thrown = this.doIllegalCall(test.getJson(), test.iterations, JsonParser::getBigDecimal);
        Assertions.assertThat((Throwable)thrown).isInstanceOf(IllegalStateException.class);
        LOG.info(thrown.getMessage());
    }

    @ParameterizedTest
    @EnumSource(value=IllegalNumberRetrievalTestCase.class)
    public void isIntegralNumberShouldThrowIllegalStateException(IllegalNumberRetrievalTestCase test) {
        Throwable thrown = this.doIllegalCall(test.getJson(), test.iterations, JsonParser::isIntegralNumber);
        Assertions.assertThat((Throwable)thrown).isInstanceOf(IllegalStateException.class);
        LOG.info(thrown.getMessage());
    }

    @ParameterizedTest
    @EnumSource(value=IllegalNumberRetrievalTestCase.class)
    public void getIntNumberShouldThrowIllegalStateException(IllegalNumberRetrievalTestCase test) {
        Throwable thrown = this.doIllegalCall(test.getJson(), test.iterations, JsonParser::getInt);
        Assertions.assertThat((Throwable)thrown).isInstanceOf(IllegalStateException.class);
        LOG.info(thrown.getMessage());
    }

    @ParameterizedTest
    @EnumSource(value=IllegalNumberRetrievalTestCase.class)
    public void getLongNumberShouldThrowIllegalStateException(IllegalNumberRetrievalTestCase test) {
        Throwable thrown = this.doIllegalCall(test.getJson(), test.iterations, JsonParser::getLong);
        Assertions.assertThat((Throwable)thrown).isInstanceOf(IllegalStateException.class);
        LOG.info(thrown.getMessage());
    }

    @ParameterizedTest
    @EnumSource(value=IllegalValueRetrievalTestCase.class)
    public void getValueShouldThrowIllegalStateException(IllegalValueRetrievalTestCase test) {
        Throwable thrown = this.doIllegalCall(test.getJson(), test.iterations, JsonParser::getValue);
        Assertions.assertThat((Throwable)thrown).isInstanceOf(IllegalStateException.class);
        LOG.info(thrown.getMessage());
    }

    private Throwable doIllegalCall(String json, int iterations, Consumer<JsonParser> consumer) {
        try (JsonParser parser = this.createJsonParser(json);){
            while (iterations-- > 0) {
                parser.next();
            }
            Throwable throwable = Assertions.catchThrowable(() -> consumer.accept(parser));
            return throwable;
        }
    }

    private JsonParser createJsonParser(String json) {
        return parserFactory.createParser((Reader)new StringReader(json));
    }

    static enum IllegalValueRetrievalTestCase implements JsonSupplier
    {
        EMPTY("", 0),
        ARRAY_CLOSING("[]", 2),
        OBJECT_CLOSING("{}", 2);

        private final String json;
        final int iterations;

        private IllegalValueRetrievalTestCase(String json, int iterations) {
            this.json = json;
            this.iterations = iterations;
        }

        @Override
        public String getJson() {
            return this.json;
        }
    }

    static enum IllegalNumberRetrievalTestCase implements JsonSupplier
    {
        EMPTY("", 0),
        TRUE("true", 1),
        FALSE("false", 1),
        NULL("null", 1),
        STRING("\"hello\"", 1),
        ARRAY_OPENING("[]", 1),
        ARRAY_CLOSING("[]", 2),
        OBJECT_OPENING("{}", 1),
        OBJECT_CLOSING("{}", 2);

        private final String json;
        final int iterations;

        private IllegalNumberRetrievalTestCase(String json, int iterations) {
            this.json = json;
            this.iterations = iterations;
        }

        @Override
        public String getJson() {
            return this.json;
        }
    }

    static enum IllegalStringRetrievalTestCase implements JsonSupplier
    {
        EMPTY("", 0),
        TRUE("true", 1),
        FALSE("false", 1),
        NULL("null", 1),
        ARRAY_OPENING("[]", 1),
        ARRAY_CLOSING("[]", 2),
        OBJECT_OPENING("{}", 1),
        OBJECT_CLOSING("{}", 2);

        private final String json;
        final int iterations;

        private IllegalStringRetrievalTestCase(String json, int iterations) {
            this.json = json;
            this.iterations = iterations;
        }

        @Override
        public String getJson() {
            return this.json;
        }
    }
}

