/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.jsonp.testsuite.tests;

import jakarta.json.Json;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParserFactory;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.leadpony.jsonp.testsuite.tests.AbstractJsonParserTest;

public class JsonParserFactoryTest {
    @Test
    public void getConfigInUseShouldReturnEmptyMap() {
        HashMap config = new HashMap();
        JsonParserFactory factory = Json.createParserFactory(config);
        Map actual = factory.getConfigInUse();
        Assertions.assertThat((Map)actual).isEmpty();
    }

    @Test
    public void getConfigInUseShouldNotContainUnknownProperty() {
        HashMap<String, Boolean> config = new HashMap<String, Boolean>();
        config.put("unknown", Boolean.TRUE);
        JsonParserFactory factory = Json.createParserFactory(config);
        Map actual = factory.getConfigInUse();
        Assertions.assertThat((Map)actual).doesNotContainKey((Object)"unknown");
    }

    public static class ReaderTest
    extends AbstractJsonParserTest {
        private static JsonParserFactory sut;

        @BeforeAll
        public static void setUpOnce() {
            sut = Json.createParserFactory(null);
        }

        @Override
        protected JsonParser createJsonParser(String json) {
            StringReader reader = new StringReader(json);
            return sut.createParser((Reader)reader);
        }
    }

    public static class InputStreamTest
    extends AbstractJsonParserTest {
        private static JsonParserFactory sut;

        @BeforeAll
        public static void setUpOnce() {
            sut = Json.createParserFactory(null);
        }

        @Override
        protected JsonParser createJsonParser(String json) {
            Charset charset = StandardCharsets.UTF_8;
            ByteArrayInputStream in = new ByteArrayInputStream(json.getBytes(charset));
            return sut.createParser((InputStream)in, charset);
        }
    }
}

