/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.jsonp.testsuite.tests;

import jakarta.json.Json;
import jakarta.json.JsonMergePatch;
import jakarta.json.JsonValue;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.leadpony.jsonp.testsuite.tests.TestCaseResource;

public class JsonMergePatchTest {
    public static Stream<MergePatchTestCase> getMergePatchTestCases() {
        return Stream.of(TestCaseResource.RFC7396_EXAMPLES, TestCaseResource.JSON_MERGE_PATCH).flatMap(TestCaseResource::getObjectStream).flatMap(object -> {
            JsonValue original = (JsonValue)object.get((Object)"source");
            return object.getJsonArray("tests").stream().map(JsonValue::asJsonObject).map(test -> new MergePatchTestCase(test.getString("description"), original, (JsonValue)test.get((Object)"patch"), (JsonValue)test.get((Object)"target")));
        });
    }

    @ParameterizedTest
    @MethodSource(value={"getMergePatchTestCases"})
    public void applyShouldApplyPatchAsExpected(MergePatchTestCase test) {
        JsonMergePatch patch = Json.createMergePatch((JsonValue)test.patch);
        JsonValue actual = patch.apply(test.source);
        Assertions.assertThat((Object)actual).isEqualTo((Object)test.target);
    }

    @ParameterizedTest
    @MethodSource(value={"getMergePatchTestCases"})
    public void toJsonValueShouldReturnJsonValue(MergePatchTestCase test) {
        JsonMergePatch patch = Json.createMergePatch((JsonValue)test.patch);
        JsonValue actual = patch.toJsonValue();
        Assertions.assertThat((Object)actual).isEqualTo((Object)test.patch);
    }

    static class MergePatchTestCase {
        final String description;
        final JsonValue source;
        final JsonValue patch;
        final JsonValue target;

        MergePatchTestCase(String description, JsonValue source, JsonValue patch, JsonValue target) {
            this.description = description;
            this.source = source;
            this.patch = patch;
            this.target = target;
        }

        public String toString() {
            return this.description;
        }
    }
}

