/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.jsonp.testsuite.tests;

import jakarta.json.Json;
import jakarta.json.JsonException;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonGeneratorFactory;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Logger;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.leadpony.jsonp.testsuite.helper.LoggerFactory;
import org.leadpony.jsonp.testsuite.helper.Writers;

public class JsonGeneratorIOExceptionTest {
    private static final Logger LOG = LoggerFactory.getLogger(JsonGeneratorIOExceptionTest.class);
    private static JsonGeneratorFactory factory;

    @BeforeAll
    public static void setUpOnce() {
        factory = Json.createGeneratorFactory(null);
    }

    @Test
    public void flushShouldThrowJsonException() {
        Writer writer = Writers.throwingWhenFlushing(new StringWriter());
        JsonGenerator g = factory.createGenerator(writer);
        Throwable thrown = Assertions.catchThrowable(() -> {
            g.write(true);
            g.flush();
        });
        Assertions.assertThat((Throwable)thrown).isInstanceOf(JsonException.class);
        LOG.info(thrown.getMessage());
    }

    @Test
    public void closeShouldThrowJsonException() {
        Writer writer = Writers.throwingWhenClosing(new StringWriter());
        JsonGenerator g = factory.createGenerator(writer);
        Throwable thrown = Assertions.catchThrowable(() -> {
            g.write(true);
            g.close();
        });
        Assertions.assertThat((Throwable)thrown).isInstanceOf(JsonException.class);
        LOG.info(thrown.getMessage());
    }
}

