/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.jsonp.testsuite.tests;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonLocation;
import jakarta.json.stream.JsonParser;
import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.leadpony.jsonp.testsuite.annotation.Ambiguous;

public abstract class AbstractJsonValueParserTest {
    private static final JsonBuilderFactory BUILDER_FACTORY = Json.createBuilderFactory(null);

    @ParameterizedTest
    @EnumSource(value=ParserEventTestCase.class)
    public void hasNextShouldReturnBooleanAsExpected(ParserEventTestCase test) {
        JsonParser parser = this.createParser(test.value);
        int events = test.events.length;
        while (events-- > 0) {
            Assertions.assertThat((boolean)parser.hasNext()).isTrue();
            parser.next();
        }
        boolean actual = parser.hasNext();
        parser.close();
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @ParameterizedTest
    @EnumSource(value=ParserEventTestCase.class)
    public void nextShouldReturnEventsAsExpected(ParserEventTestCase test) {
        ArrayList<JsonParser.Event> actual = new ArrayList<JsonParser.Event>();
        try (JsonParser parser = this.createParser(test.value);){
            while (parser.hasNext()) {
                actual.add(parser.next());
            }
        }
        Assertions.assertThat(actual).containsExactly((Object[])test.events);
    }

    @ParameterizedTest
    @EnumSource(value=ParserEventTestCase.class)
    public void nextShouldThrowNoSuchElementExceptionAfterFinalEvent(ParserEventTestCase test) {
        Throwable thrown = null;
        try (JsonParser parser = this.createParser(test.value);){
            while (parser.hasNext()) {
                parser.next();
            }
            thrown = Assertions.catchThrowable(() -> parser.next());
        }
        Assertions.assertThat((Throwable)thrown).isInstanceOf(NoSuchElementException.class);
    }

    @ParameterizedTest
    @EnumSource(value=StringTestCase.class)
    public void getStringShouldReturnStringAsExpected(StringTestCase test) {
        String actual = this.extractValue(test.json, test.iterations, JsonParser::getString);
        Assertions.assertThat((String)actual).isEqualTo(test.value);
    }

    @ParameterizedTest
    @EnumSource(value=IsIntegralNumberTestCase.class)
    public void isIntegralNumberShouldReturnBooleanAsExpected(IsIntegralNumberTestCase test) {
        boolean actual = this.extractValue(test.json, test.iterations, JsonParser::isIntegralNumber);
        Assertions.assertThat((boolean)actual).isEqualTo(test.value);
    }

    @ParameterizedTest
    @EnumSource(value=IntTestCase.class)
    public void getIntShouldReturnIntAsExpected(IntTestCase test) {
        int actual = this.extractValue(test.json, test.iterations, JsonParser::getInt);
        Assertions.assertThat((int)actual).isEqualTo(test.value);
    }

    @ParameterizedTest
    @EnumSource(value=LongTestCase.class)
    public void getLongShouldReturnLongAsExpected(LongTestCase test) {
        long actual = this.extractValue(test.json, test.iterations, JsonParser::getLong);
        Assertions.assertThat((long)actual).isEqualTo(test.value);
    }

    @ParameterizedTest
    @EnumSource(value=BigDecimalTestCase.class)
    public void getBigDecimalShouldReturnBigDecimalAsExpected(BigDecimalTestCase test) {
        BigDecimal actual = this.extractValue(test.json, test.iterations, JsonParser::getBigDecimal);
        Assertions.assertThat((BigDecimal)actual).isEqualTo((Object)test.value);
    }

    @ParameterizedTest
    @EnumSource(value=ParserEventTestCase.class)
    public void getLocationShouldReturnUnknownLocation(ParserEventTestCase test) {
        JsonParser parser = this.createParser(test.value);
        while (parser.hasNext()) {
            parser.next();
            JsonLocation actual = parser.getLocation();
            Assertions.assertThat((Object)actual).isNotNull();
        }
        parser.close();
    }

    @ParameterizedTest
    @EnumSource(value=ParserEventTestCase.class)
    public void getLocationShouldReturnUnknownLocationAtStart(ParserEventTestCase test) {
        JsonParser parser = this.createParser(test.value);
        JsonLocation actual = parser.getLocation();
        parser.close();
        Assertions.assertThat((Object)actual).isNotNull();
    }

    @ParameterizedTest
    @EnumSource(value=ParserEventTestCase.class)
    public void getLocationShouldReturnUnknownLocationAtEnd(ParserEventTestCase test) {
        JsonParser parser = this.createParser(test.value);
        while (parser.hasNext()) {
            parser.next();
        }
        JsonLocation actual = parser.getLocation();
        parser.close();
        Assertions.assertThat((Object)actual).isNotNull();
    }

    @ParameterizedTest
    @EnumSource(value=ValueTestCase.class)
    public void getValueShouldReturnJsonValueAsExpected(ValueTestCase test) {
        JsonValue actual = this.extractValue(test.json, test.iterations, JsonParser::getValue);
        Assertions.assertThat((Object)actual).isEqualTo((Object)test.value);
    }

    @ParameterizedTest
    @EnumSource(value=ValueTestCase.class)
    public void getValueShouldMoveToNextEventAsExpected(ValueTestCase test) {
        JsonParser.Event actual = this.getEventAfterValue(test.json, test.iterations, JsonParser::getValue);
        Assertions.assertThat((Comparable)actual).isEqualTo((Object)test.event);
    }

    public static Stream<ValueTestCase> getArrayShouldReturnArrayAsExpected() {
        return Stream.of(ValueTestCase.values()).filter(ValueTestCase::isArray);
    }

    @ParameterizedTest
    @MethodSource
    public void getArrayShouldReturnArrayAsExpected(ValueTestCase test) {
        JsonArray actual = this.extractValue(test.json, test.iterations, JsonParser::getArray);
        Assertions.assertThat((List)actual).isEqualTo((Object)test.value);
        Assertions.assertThat((Comparable)actual.getValueType()).isSameAs((Object)JsonValue.ValueType.ARRAY);
    }

    @ParameterizedTest
    @MethodSource(value={"getArrayShouldReturnArrayAsExpected"})
    public void getArrayShouldMoveToNextEventAsExpected(ValueTestCase test) {
        JsonParser.Event actual = this.getEventAfterValue(test.json, test.iterations, JsonParser::getArray);
        Assertions.assertThat((Comparable)actual).isEqualTo((Object)test.event);
    }

    public static Stream<ValueTestCase> getObjectShouldReturnObjectAsExpected() {
        return Stream.of(ValueTestCase.values()).filter(ValueTestCase::isObject);
    }

    @ParameterizedTest
    @MethodSource
    public void getObjectShouldReturnObjectAsExpected(ValueTestCase test) {
        JsonObject actual = this.extractValue(test.json, test.iterations, JsonParser::getObject);
        Assertions.assertThat((Map)actual).isEqualTo((Object)test.value);
        Assertions.assertThat((Comparable)actual.getValueType()).isSameAs((Object)JsonValue.ValueType.OBJECT);
    }

    @ParameterizedTest
    @MethodSource(value={"getObjectShouldReturnObjectAsExpected"})
    public void getObjectShouldMoveToNextEventAsExpected(ValueTestCase test) {
        JsonParser.Event actual = this.getEventAfterValue(test.json, test.iterations, JsonParser::getObject);
        Assertions.assertThat((Comparable)actual).isEqualTo((Object)test.event);
    }

    @ParameterizedTest
    @EnumSource(value=GetArrayStreamTestCase.class)
    public void getArrayStreamShouldReturnArrayStreamAsExpected(GetArrayStreamTestCase test) {
        JsonParser parser = this.createParser(test.value);
        int iterations = test.iterations;
        while (iterations-- > 0) {
            parser.next();
        }
        Assertions.assertThatCode(() -> {
            Stream actual = parser.getArrayStream();
            Assertions.assertThat((Stream)actual).containsExactly((Object[])test.expected);
        }).doesNotThrowAnyException();
        parser.close();
    }

    @ParameterizedTest
    @EnumSource(value=GetObjectArrayTestCase.class)
    public void getObjectStreamShouldReturnObjectStreamAsExpected(GetObjectArrayTestCase test) {
        JsonParser parser = this.createParser(test.value);
        int iterations = test.iterations;
        while (iterations-- > 0) {
            parser.next();
        }
        Assertions.assertThatCode(() -> {
            Stream actual = parser.getObjectStream();
            Assertions.assertThat((Stream)actual).containsExactly((Object[])test.expected);
        }).doesNotThrowAnyException();
        parser.close();
    }

    @ParameterizedTest
    @EnumSource(value=SkipArrayTestCase.class)
    public void skipArrayShouldSkipArrayAsExpected(SkipArrayTestCase test) {
        JsonParser parser = this.createParser(test.value);
        int iterations = test.iterations;
        while (iterations-- > 0) {
            parser.next();
        }
        parser.skipArray();
        JsonParser.Event actual = parser.hasNext() ? parser.next() : null;
        parser.close();
        Assertions.assertThat((Comparable)actual).isEqualTo((Object)test.expected);
    }

    @Ambiguous
    @ParameterizedTest
    @EnumSource(value=SkipHalfwayArrayTestCase.class)
    public void skipArrayShouldSkipHalfwayArrayAsExpected(SkipHalfwayArrayTestCase test) {
        JsonParser parser = this.createParser(test.value);
        int iterations = test.iterations;
        while (iterations-- > 0) {
            parser.next();
        }
        try {
            parser.skipArray();
        }
        catch (Exception e) {
            org.junit.jupiter.api.Assertions.fail((Throwable)e);
        }
        JsonParser.Event actual = parser.hasNext() ? parser.next() : null;
        parser.close();
        Assertions.assertThat((Comparable)actual).isEqualTo((Object)test.expected);
    }

    @ParameterizedTest
    @EnumSource(value=SkipObjectTestCase.class)
    public void skipObjectShouldSkipObjectAsExpected(SkipObjectTestCase test) {
        JsonParser parser = this.createParser(test.value);
        int iterations = test.iterations;
        while (iterations-- > 0) {
            parser.next();
        }
        parser.skipObject();
        JsonParser.Event actual = parser.hasNext() ? parser.next() : null;
        parser.close();
        Assertions.assertThat((Comparable)actual).isEqualTo((Object)test.expected);
    }

    @Ambiguous
    @ParameterizedTest
    @EnumSource(value=SkipHalfwayObjectTestCase.class)
    public void skipObjectShouldSkipHalfwayObjectAsExpected(SkipHalfwayObjectTestCase test) {
        JsonParser parser = this.createParser(test.value);
        int iterations = test.iterations;
        while (iterations-- > 0) {
            parser.next();
        }
        try {
            parser.skipObject();
        }
        catch (Exception e) {
            org.junit.jupiter.api.Assertions.fail((Throwable)e);
        }
        JsonParser.Event actual = parser.hasNext() ? parser.next() : null;
        parser.close();
        Assertions.assertThat((Comparable)actual).isEqualTo((Object)test.expected);
    }

    private <T> T extractValue(JsonStructure value, int iterations, Function<JsonParser, T> mapper) {
        AtomicReference result = new AtomicReference();
        try (JsonParser parser = this.createParser(value);){
            while (iterations-- > 0) {
                parser.next();
            }
            Assertions.assertThatCode(() -> result.set(mapper.apply(parser))).doesNotThrowAnyException();
        }
        return (T)result.get();
    }

    private JsonParser.Event getEventAfterValue(JsonStructure value, int iterations, Function<JsonParser, ?> mapper) {
        try (JsonParser parser = this.createParser(value);){
            while (iterations-- > 0) {
                parser.next();
            }
            Assertions.assertThatCode(() -> mapper.apply(parser)).doesNotThrowAnyException();
            if (parser.hasNext()) {
                JsonParser.Event event = parser.next();
                return event;
            }
            JsonParser.Event event = null;
            return event;
        }
    }

    protected abstract JsonParser createParser(JsonStructure var1);

    private static JsonArray array(Consumer<JsonArrayBuilder> consumer) {
        JsonArrayBuilder builder = BUILDER_FACTORY.createArrayBuilder();
        consumer.accept(builder);
        return builder.build();
    }

    private static JsonObject object(Consumer<JsonObjectBuilder> consumer) {
        JsonObjectBuilder builder = BUILDER_FACTORY.createObjectBuilder();
        consumer.accept(builder);
        return builder.build();
    }

    public static enum SkipHalfwayObjectTestCase {
        OBJECT((JsonStructure)AbstractJsonValueParserTest.access$100(b -> b.add("a", 365).add("b", "hello")), 2, null),
        OBJECT_END((JsonStructure)AbstractJsonValueParserTest.access$100(b -> b.add("a", 365).add("b", "hello")), 6, null),
        IN_ARRAY((JsonStructure)AbstractJsonValueParserTest.access$100(b -> b.add("a", (JsonValue)AbstractJsonValueParserTest.array(b2 -> b2.add(1).add(2)))), 4, null);

        final JsonStructure value;
        final int iterations;
        final JsonParser.Event expected;

        private SkipHalfwayObjectTestCase(JsonStructure value, int iterations, JsonParser.Event expected) {
            this.value = value;
            this.iterations = iterations;
            this.expected = expected;
        }
    }

    public static enum SkipObjectTestCase {
        OBJECT((JsonStructure)AbstractJsonValueParserTest.access$100(b -> b.add("a", 365).add("b", "hello")), 1, null),
        OBJECT_IN_ARRAY((JsonStructure)AbstractJsonValueParserTest.access$000(b -> b.add((JsonValue)SkipObjectTestCase.OBJECT.value).add((JsonValue)SkipObjectTestCase.OBJECT.value)), 2, JsonParser.Event.START_OBJECT),
        SECOND_OBJECT_IN_ARRAY(SkipObjectTestCase.OBJECT_IN_ARRAY.value, 8, JsonParser.Event.END_ARRAY),
        OBJECT_IN_OBJECT((JsonStructure)AbstractJsonValueParserTest.access$100(b -> b.add("p", (JsonValue)SkipObjectTestCase.OBJECT.value).add("q", (JsonValue)SkipObjectTestCase.OBJECT.value)), 3, JsonParser.Event.KEY_NAME),
        SECOND_OBJECT_IN_OBJECT(SkipObjectTestCase.OBJECT_IN_OBJECT.value, 10, JsonParser.Event.END_OBJECT),
        SKIP_NESTED_ARRAY((JsonStructure)AbstractJsonValueParserTest.access$100(b -> {
            b.add("a", (JsonValue)AbstractJsonValueParserTest.object(b2 -> b2.add("b", (JsonValue)AbstractJsonValueParserTest.array(b3 -> b3.add(1).add(2)))));
            b.add("c", 3);
        }), 3, JsonParser.Event.KEY_NAME),
        SKIP_NESTED_OBJECT((JsonStructure)AbstractJsonValueParserTest.access$100(b -> {
            b.add("a", (JsonValue)AbstractJsonValueParserTest.object(b2 -> b2.add("b", (JsonValue)AbstractJsonValueParserTest.object(b3 -> b3.add("c", 1)))));
            b.add("d", 2);
        }), 3, JsonParser.Event.KEY_NAME),
        EMPTY_OBJECT((JsonStructure)JsonValue.EMPTY_JSON_OBJECT, 1, null);

        final JsonStructure value;
        final int iterations;
        final JsonParser.Event expected;

        private SkipObjectTestCase(JsonStructure value, int iterations, JsonParser.Event expected) {
            this.value = value;
            this.iterations = iterations;
            this.expected = expected;
        }
    }

    public static enum SkipHalfwayArrayTestCase {
        ARRAY((JsonStructure)AbstractJsonValueParserTest.access$000(b -> b.add(1).add(2).add(3)), 3, null),
        ARRAY_END((JsonStructure)AbstractJsonValueParserTest.access$000(b -> b.add(1).add(2).add(3)), 5, null),
        IN_OBJECT((JsonStructure)AbstractJsonValueParserTest.access$000(b -> {
            b.add(1);
            b.add((JsonValue)AbstractJsonValueParserTest.object(b2 -> b2.add("a", 2)));
            b.add(3);
        }), 4, null);

        final JsonStructure value;
        final int iterations;
        final JsonParser.Event expected;

        private SkipHalfwayArrayTestCase(JsonStructure value, int iterations, JsonParser.Event expected) {
            this.value = value;
            this.iterations = iterations;
            this.expected = expected;
        }
    }

    public static enum SkipArrayTestCase {
        ARRAY((JsonStructure)AbstractJsonValueParserTest.access$000(b -> b.add(1).add(2).add(3)), 1, null),
        ARRAY_IN_ARRAY((JsonStructure)AbstractJsonValueParserTest.access$000(b -> b.add((JsonValue)SkipArrayTestCase.ARRAY.value).add((JsonValue)SkipArrayTestCase.ARRAY.value)), 2, JsonParser.Event.START_ARRAY),
        SECOND_ARRAY_IN_ARRAY(SkipArrayTestCase.ARRAY_IN_ARRAY.value, 7, JsonParser.Event.END_ARRAY),
        ARRAY_IN_OBJECT((JsonStructure)AbstractJsonValueParserTest.access$100(b -> b.add("a", (JsonValue)SkipArrayTestCase.ARRAY.value).add("b", (JsonValue)SkipArrayTestCase.ARRAY.value)), 3, JsonParser.Event.KEY_NAME),
        SECOND_ARRAY_IN_OBJECT(SkipArrayTestCase.ARRAY_IN_OBJECT.value, 9, JsonParser.Event.END_OBJECT),
        SKIP_NESTED_ARRAY((JsonStructure)AbstractJsonValueParserTest.access$000(b -> {
            b.add((JsonValue)AbstractJsonValueParserTest.array(b2 -> {
                b2.add(1);
                b2.add(2);
                b2.add((JsonValue)AbstractJsonValueParserTest.array(b3 -> b3.add(3).add(4)));
            }));
            b.add((JsonValue)AbstractJsonValueParserTest.array(b2 -> {
                b2.add(5);
                b2.add(6);
            }));
        }), 2, JsonParser.Event.START_ARRAY),
        SKIP_NESTED_OBJECT((JsonStructure)AbstractJsonValueParserTest.access$000(b -> {
            b.add((JsonValue)AbstractJsonValueParserTest.array(b2 -> {
                b2.add(1);
                b2.add(2);
                b2.add((JsonValue)AbstractJsonValueParserTest.object(b3 -> b3.add("a", 3)));
            }));
            b.add((JsonValue)AbstractJsonValueParserTest.array(b2 -> {
                b2.add(4);
                b2.add(5);
            }));
        }), 2, JsonParser.Event.START_ARRAY),
        EMPTY_ARRAY((JsonStructure)JsonValue.EMPTY_JSON_ARRAY, 1, null);

        final JsonStructure value;
        final int iterations;
        final JsonParser.Event expected;

        private SkipArrayTestCase(JsonStructure value, int iterations, JsonParser.Event expected) {
            this.value = value;
            this.iterations = iterations;
            this.expected = expected;
        }
    }

    public static enum GetObjectArrayTestCase {
        OBJECT((JsonStructure)AbstractJsonValueParserTest.access$100(b -> {
            b.add("a", "hello");
            b.add("b", 42);
            b.add("c", true);
            b.add("d", false);
            b.addNull("e");
        }), 1, GetObjectArrayTestCase.entry("a", (JsonValue)Json.createValue((String)"hello")), GetObjectArrayTestCase.entry("b", (JsonValue)Json.createValue((int)42)), GetObjectArrayTestCase.entry("c", JsonValue.TRUE), GetObjectArrayTestCase.entry("d", JsonValue.FALSE), GetObjectArrayTestCase.entry("e", JsonValue.NULL)),
        OBJECT_IN_ARRAY((JsonStructure)AbstractJsonValueParserTest.access$000(b -> {
            b.add((JsonValue)AbstractJsonValueParserTest.object(b2 -> b2.add("a", "hello").add("b", 42)));
            b.add((JsonValue)AbstractJsonValueParserTest.object(b2 -> b2.add("c", true).add("d", false).addNull("e")));
        }), 2, GetObjectArrayTestCase.entry("a", (JsonValue)Json.createValue((String)"hello")), GetObjectArrayTestCase.entry("b", (JsonValue)Json.createValue((int)42))),
        SECOND_OBJECT_IN_ARRAY(GetObjectArrayTestCase.OBJECT_IN_ARRAY.value, 8, GetObjectArrayTestCase.entry("c", JsonValue.TRUE), GetObjectArrayTestCase.entry("d", JsonValue.FALSE), GetObjectArrayTestCase.entry("e", JsonValue.NULL)),
        OBJECT_IN_OBJECT((JsonStructure)AbstractJsonValueParserTest.access$100(b -> {
            b.add("p", (JsonValue)AbstractJsonValueParserTest.object(b2 -> b2.add("a", "hello").add("b", 42)));
            b.add("q", (JsonValue)AbstractJsonValueParserTest.object(b2 -> b2.add("c", true).add("d", false).addNull("e")));
        }), 3, GetObjectArrayTestCase.entry("a", (JsonValue)Json.createValue((String)"hello")), GetObjectArrayTestCase.entry("b", (JsonValue)Json.createValue((int)42))),
        SECOND_OBJECT_IN_OBJECT(GetObjectArrayTestCase.OBJECT_IN_OBJECT.value, 10, GetObjectArrayTestCase.entry("c", JsonValue.TRUE), GetObjectArrayTestCase.entry("d", JsonValue.FALSE), GetObjectArrayTestCase.entry("e", JsonValue.NULL)),
        EMPTY_OBJECT((JsonStructure)JsonValue.EMPTY_JSON_OBJECT, 1, new Map.Entry[0]);

        final JsonStructure value;
        final int iterations;
        final Map.Entry<String, JsonValue>[] expected;

        @SafeVarargs
        private GetObjectArrayTestCase(JsonStructure value, int iterations, Map.Entry<String, JsonValue> ... expected) {
            this.value = value;
            this.iterations = iterations;
            this.expected = expected;
        }

        private static Map.Entry<String, JsonValue> entry(String key, JsonValue value) {
            return new AbstractMap.SimpleImmutableEntry<String, JsonValue>(key, value);
        }
    }

    public static enum GetArrayStreamTestCase {
        ARRAY((JsonStructure)AbstractJsonValueParserTest.access$000(b -> {
            b.add("hello");
            b.add(42);
            b.add(true);
            b.add(false);
            b.addNull();
        }), 1, new JsonValue[]{Json.createValue((String)"hello"), Json.createValue((int)42), JsonValue.TRUE, JsonValue.FALSE, JsonValue.NULL}),
        ARRAY_IN_ARRAY((JsonStructure)AbstractJsonValueParserTest.access$000(b -> {
            b.add((JsonValue)AbstractJsonValueParserTest.array(b2 -> b2.add("hello").add(42)));
            b.add((JsonValue)AbstractJsonValueParserTest.array(b2 -> b2.add(true).add(false).addNull()));
        }), 2, new JsonValue[]{Json.createValue((String)"hello"), Json.createValue((int)42)}),
        SECOND_ARRAY_IN_ARRAY(GetArrayStreamTestCase.ARRAY_IN_ARRAY.value, 6, JsonValue.TRUE, JsonValue.FALSE, JsonValue.NULL),
        ARRAY_IN_OBJECT((JsonStructure)AbstractJsonValueParserTest.access$100(b -> {
            b.add("a", (JsonValue)AbstractJsonValueParserTest.array(b2 -> b2.add("hello").add(42)));
            b.add("b", (JsonValue)AbstractJsonValueParserTest.array(b2 -> b2.add(true).add(false).addNull()));
        }), 3, new JsonValue[]{Json.createValue((String)"hello"), Json.createValue((int)42)}),
        SECOND_ARRAY_IN_OBJECT(GetArrayStreamTestCase.ARRAY_IN_OBJECT.value, 8, JsonValue.TRUE, JsonValue.FALSE, JsonValue.NULL),
        EMPTY_ARRAY((JsonStructure)JsonValue.EMPTY_JSON_ARRAY, 1, new JsonValue[0]);

        final JsonStructure value;
        final int iterations;
        final JsonValue[] expected;

        private GetArrayStreamTestCase(JsonStructure value, int iterations, JsonValue ... expected) {
            this.value = value;
            this.iterations = iterations;
            this.expected = expected;
        }
    }

    public static enum ValueTestCase {
        SIMPLE_ARRAY((JsonStructure)AbstractJsonValueParserTest.access$000(b -> b.add("hello").add(42).add(true).add(false).addNull())),
        STRING_IN_ARRAY(ValueTestCase.SIMPLE_ARRAY.json, 2, (JsonValue)Json.createValue((String)"hello"), JsonParser.Event.VALUE_NUMBER),
        NUMBER_IN_ARRAY(ValueTestCase.SIMPLE_ARRAY.json, 3, (JsonValue)Json.createValue((int)42), JsonParser.Event.VALUE_TRUE),
        TRUE_IN_ARRAY(ValueTestCase.SIMPLE_ARRAY.json, 4, JsonValue.TRUE, JsonParser.Event.VALUE_FALSE),
        FALSE_IN_ARRAY(ValueTestCase.SIMPLE_ARRAY.json, 5, JsonValue.FALSE, JsonParser.Event.VALUE_NULL),
        NULL_IN_ARRAY(ValueTestCase.SIMPLE_ARRAY.json, 6, JsonValue.NULL, JsonParser.Event.END_ARRAY),
        SIMPLE_OBJECT((JsonStructure)AbstractJsonValueParserTest.access$100(b -> b.add("a", "hello").add("b", 42).add("c", true).add("d", false).addNull("e"))),
        STRING_IN_OBJECT(ValueTestCase.SIMPLE_OBJECT.json, 3, (JsonValue)Json.createValue((String)"hello"), JsonParser.Event.KEY_NAME),
        NUMBER_IN_OBJECT(ValueTestCase.SIMPLE_OBJECT.json, 5, (JsonValue)Json.createValue((int)42), JsonParser.Event.KEY_NAME),
        TRUE_IN_OBJECT(ValueTestCase.SIMPLE_OBJECT.json, 7, JsonValue.TRUE, JsonParser.Event.KEY_NAME),
        FALSE_IN_OBJECT(ValueTestCase.SIMPLE_OBJECT.json, 9, JsonValue.FALSE, JsonParser.Event.KEY_NAME),
        NULL_IN_OBJECT(ValueTestCase.SIMPLE_OBJECT.json, 11, JsonValue.NULL, JsonParser.Event.END_OBJECT),
        ARRAY_IN_ARRAY((JsonStructure)AbstractJsonValueParserTest.access$000(b -> b.add((JsonValue)ValueTestCase.SIMPLE_ARRAY.json).add((JsonValue)ValueTestCase.SIMPLE_OBJECT.json)), 2, (JsonValue)ValueTestCase.SIMPLE_ARRAY.json, JsonParser.Event.START_OBJECT),
        OBJECT_IN_ARRAY((JsonStructure)AbstractJsonValueParserTest.access$000(b -> b.add((JsonValue)ValueTestCase.SIMPLE_ARRAY.json).add((JsonValue)ValueTestCase.SIMPLE_OBJECT.json)), 9, (JsonValue)ValueTestCase.SIMPLE_OBJECT.json, JsonParser.Event.END_ARRAY);

        final JsonStructure json;
        final int iterations;
        final JsonValue value;
        final JsonParser.Event event;

        private ValueTestCase(JsonStructure json) {
            this.json = json;
            this.iterations = 1;
            this.value = json;
            this.event = null;
        }

        private ValueTestCase(JsonStructure json, int iterations, JsonValue value, JsonParser.Event event) {
            this.json = json;
            this.iterations = iterations;
            this.value = value;
            this.event = event;
        }

        boolean isArray() {
            return this.value.getValueType() == JsonValue.ValueType.ARRAY;
        }

        boolean isObject() {
            return this.value.getValueType() == JsonValue.ValueType.OBJECT;
        }
    }

    public static enum BigDecimalTestCase {
        ZERO_IN_ARRAY((JsonStructure)AbstractJsonValueParserTest.access$000(b -> b.add(0)), 2, BigDecimal.ZERO),
        ONE_IN_ARRAY((JsonStructure)AbstractJsonValueParserTest.access$000(b -> b.add(1)), 2, BigDecimal.ONE),
        TEN_IN_ARRAY((JsonStructure)AbstractJsonValueParserTest.access$000(b -> b.add(10)), 2, BigDecimal.TEN),
        NUMBER_AS_FIRST_ITEM((JsonStructure)AbstractJsonValueParserTest.access$000(b -> b.add(42).add(new BigDecimal("3.14"))), 2, new BigDecimal(42)),
        NUMBER_AS_LAST_ITEM(BigDecimalTestCase.NUMBER_AS_FIRST_ITEM.json, 3, new BigDecimal("3.14")),
        NUMBER_AS_FIRST_PROPERTY_VALUE((JsonStructure)AbstractJsonValueParserTest.access$100(b -> b.add("a", 42).add("b", new BigDecimal("3.14"))), 3, new BigDecimal(42)),
        NUMBER_AS_LAST_PROPERTY_VALUE(BigDecimalTestCase.NUMBER_AS_FIRST_PROPERTY_VALUE.json, 5, new BigDecimal("3.14"));

        final JsonStructure json;
        final int iterations;
        final BigDecimal value;

        private BigDecimalTestCase(JsonStructure json, int iterations, BigDecimal value) {
            this.json = json;
            this.iterations = iterations;
            this.value = value;
        }
    }

    public static enum LongTestCase {
        NUMBER_AS_FIRST_ITEM((JsonStructure)AbstractJsonValueParserTest.access$000(b -> b.add(Long.MAX_VALUE).add(Long.MIN_VALUE)), 2, Long.MAX_VALUE),
        NUMBER_AS_LAST_ITEM(LongTestCase.NUMBER_AS_FIRST_ITEM.json, 3, Long.MIN_VALUE),
        NUMBER_AS_FIRST_PROPERTY_VALUE((JsonStructure)AbstractJsonValueParserTest.access$100(b -> b.add("a", Long.MAX_VALUE).add("b", Long.MIN_VALUE)), 3, Long.MAX_VALUE),
        NUMBER_AS_LAST_PROPERTY_VALUE(LongTestCase.NUMBER_AS_FIRST_PROPERTY_VALUE.json, 5, Long.MIN_VALUE);

        final JsonStructure json;
        final int iterations;
        final long value;

        private LongTestCase(JsonStructure json, int iterations, long value) {
            this.json = json;
            this.iterations = iterations;
            this.value = value;
        }
    }

    public static enum IntTestCase {
        NUMBER_AS_FIRST_ITEM((JsonStructure)AbstractJsonValueParserTest.access$000(b -> b.add(Integer.MAX_VALUE).add(Integer.MIN_VALUE)), 2, Integer.MAX_VALUE),
        NUMBER_AS_LAST_ITEM(IntTestCase.NUMBER_AS_FIRST_ITEM.json, 3, Integer.MIN_VALUE),
        NUMBER_AS_FIRST_PROPERTY_VALUE((JsonStructure)AbstractJsonValueParserTest.access$100(b -> b.add("a", Integer.MAX_VALUE).add("b", Integer.MIN_VALUE)), 3, Integer.MAX_VALUE),
        NUMBER_AS_LAST_PROPERTY_VALUE(IntTestCase.NUMBER_AS_FIRST_PROPERTY_VALUE.json, 5, Integer.MIN_VALUE);

        final JsonStructure json;
        final int iterations;
        final int value;

        private IntTestCase(JsonStructure json, int iterations, int value) {
            this.json = json;
            this.iterations = iterations;
            this.value = value;
        }
    }

    public static enum IsIntegralNumberTestCase {
        NUMBER_AS_FIRST_ITEM((JsonStructure)AbstractJsonValueParserTest.access$000(b -> b.add(42).add(new BigDecimal("3.14"))), 2, true),
        NUMBER_AS_LAST_ITEM(IsIntegralNumberTestCase.NUMBER_AS_FIRST_ITEM.json, 3, false),
        NUMBER_AS_FIRST_PROPERTY_VALUE((JsonStructure)AbstractJsonValueParserTest.access$100(b -> b.add("a", 42).add("b", new BigDecimal("3.14"))), 3, true),
        NUMBER_AS_LAST_PROPERTY_VALUE(IsIntegralNumberTestCase.NUMBER_AS_FIRST_PROPERTY_VALUE.json, 5, false);

        final JsonStructure json;
        final int iterations;
        final boolean value;

        private IsIntegralNumberTestCase(JsonStructure json, int iterations, boolean value) {
            this.json = json;
            this.iterations = iterations;
            this.value = value;
        }
    }

    public static enum StringTestCase {
        STRING_AS_FIRST_ITEM((JsonStructure)AbstractJsonValueParserTest.access$000(b -> b.add("hello").add("world")), 2, "hello"),
        STRING_AS_LAST_ITEM(StringTestCase.STRING_AS_FIRST_ITEM.json, 3, "world"),
        NUMBER_AS_FIRST_ITEM((JsonStructure)AbstractJsonValueParserTest.access$000(b -> b.add(42).add(new BigDecimal("3.14"))), 2, "42"),
        NUMBER_AS_LAST_ITEM(StringTestCase.NUMBER_AS_FIRST_ITEM.json, 3, "3.14"),
        STRING_AS_FIRST_PROPERTY_VALUE((JsonStructure)AbstractJsonValueParserTest.access$100(b -> b.add("a", "hello").add("b", "world")), 3, "hello"),
        STRING_AS_LAST_PROPERTY_VALUE(StringTestCase.STRING_AS_FIRST_PROPERTY_VALUE.json, 5, "world"),
        NUMBER_AS_FIRST_PROPERTY_VALUE((JsonStructure)AbstractJsonValueParserTest.access$100(b -> b.add("a", 42).add("b", new BigDecimal("3.14"))), 3, "42"),
        NUMBER_AS_LAST_PROPERTY_VALUE(StringTestCase.NUMBER_AS_FIRST_PROPERTY_VALUE.json, 5, "3.14"),
        STRING_AS_FIRST_PROPERTY_KEY((JsonStructure)AbstractJsonValueParserTest.access$100(b -> b.add("hello", 1).add("world", 2)), 2, "hello"),
        STRING_AS_LAST_PROPERTY_KEY(StringTestCase.STRING_AS_FIRST_PROPERTY_KEY.json, 4, "world");

        final JsonStructure json;
        final int iterations;
        final String value;

        private StringTestCase(JsonStructure json, int iterations, String value) {
            this.json = json;
            this.iterations = iterations;
            this.value = value;
        }
    }

    public static enum ParserEventTestCase {
        EMPTY_ARRAY((JsonStructure)JsonValue.EMPTY_JSON_ARRAY, JsonParser.Event.START_ARRAY, JsonParser.Event.END_ARRAY),
        SIMPLE_ARRAY((JsonStructure)AbstractJsonValueParserTest.access$000(b -> b.add("hello").add(42).add(true).add(false).addNull()), JsonParser.Event.START_ARRAY, JsonParser.Event.VALUE_STRING, JsonParser.Event.VALUE_NUMBER, JsonParser.Event.VALUE_TRUE, JsonParser.Event.VALUE_FALSE, JsonParser.Event.VALUE_NULL, JsonParser.Event.END_ARRAY),
        ARRAY_OF_EMPTY_ARRAYS((JsonStructure)AbstractJsonValueParserTest.access$000(b -> {
            b.add((JsonValue)JsonValue.EMPTY_JSON_ARRAY);
            b.add((JsonValue)JsonValue.EMPTY_JSON_ARRAY);
            b.add((JsonValue)JsonValue.EMPTY_JSON_ARRAY);
        }), JsonParser.Event.START_ARRAY, JsonParser.Event.START_ARRAY, JsonParser.Event.END_ARRAY, JsonParser.Event.START_ARRAY, JsonParser.Event.END_ARRAY, JsonParser.Event.START_ARRAY, JsonParser.Event.END_ARRAY, JsonParser.Event.END_ARRAY),
        ARRAY_OF_EMPTY_OBJECTS((JsonStructure)AbstractJsonValueParserTest.access$000(b -> {
            b.add((JsonValue)JsonValue.EMPTY_JSON_OBJECT);
            b.add((JsonValue)JsonValue.EMPTY_JSON_OBJECT);
            b.add((JsonValue)JsonValue.EMPTY_JSON_OBJECT);
        }), JsonParser.Event.START_ARRAY, JsonParser.Event.START_OBJECT, JsonParser.Event.END_OBJECT, JsonParser.Event.START_OBJECT, JsonParser.Event.END_OBJECT, JsonParser.Event.START_OBJECT, JsonParser.Event.END_OBJECT, JsonParser.Event.END_ARRAY),
        ARRAY_OF_ARRAYS((JsonStructure)AbstractJsonValueParserTest.access$000(b -> {
            b.add((JsonValue)AbstractJsonValueParserTest.array(b2 -> b2.add(1).add(2).add(3)));
            b.add((JsonValue)AbstractJsonValueParserTest.array(b2 -> b2.add(4).add(5).add(6)));
        }), JsonParser.Event.START_ARRAY, JsonParser.Event.START_ARRAY, JsonParser.Event.VALUE_NUMBER, JsonParser.Event.VALUE_NUMBER, JsonParser.Event.VALUE_NUMBER, JsonParser.Event.END_ARRAY, JsonParser.Event.START_ARRAY, JsonParser.Event.VALUE_NUMBER, JsonParser.Event.VALUE_NUMBER, JsonParser.Event.VALUE_NUMBER, JsonParser.Event.END_ARRAY, JsonParser.Event.END_ARRAY),
        ARRAY_OF_OBJECTS((JsonStructure)AbstractJsonValueParserTest.access$000(b -> {
            b.add((JsonValue)AbstractJsonValueParserTest.object(b2 -> b2.add("a", "hello").add("b", 42)));
            b.add((JsonValue)AbstractJsonValueParserTest.object(b2 -> b2.add("c", true).add("d", false).addNull("e")));
        }), JsonParser.Event.START_ARRAY, JsonParser.Event.START_OBJECT, JsonParser.Event.KEY_NAME, JsonParser.Event.VALUE_STRING, JsonParser.Event.KEY_NAME, JsonParser.Event.VALUE_NUMBER, JsonParser.Event.END_OBJECT, JsonParser.Event.START_OBJECT, JsonParser.Event.KEY_NAME, JsonParser.Event.VALUE_TRUE, JsonParser.Event.KEY_NAME, JsonParser.Event.VALUE_FALSE, JsonParser.Event.KEY_NAME, JsonParser.Event.VALUE_NULL, JsonParser.Event.END_OBJECT, JsonParser.Event.END_ARRAY),
        EMPTY_OBJECT((JsonStructure)JsonValue.EMPTY_JSON_OBJECT, JsonParser.Event.START_OBJECT, JsonParser.Event.END_OBJECT),
        SIMPLE_OBJECT((JsonStructure)AbstractJsonValueParserTest.access$100(b -> {
            b.add("a", "hello");
            b.add("b", 42);
            b.add("c", true);
            b.add("d", false);
            b.addNull("e");
        }), JsonParser.Event.START_OBJECT, JsonParser.Event.KEY_NAME, JsonParser.Event.VALUE_STRING, JsonParser.Event.KEY_NAME, JsonParser.Event.VALUE_NUMBER, JsonParser.Event.KEY_NAME, JsonParser.Event.VALUE_TRUE, JsonParser.Event.KEY_NAME, JsonParser.Event.VALUE_FALSE, JsonParser.Event.KEY_NAME, JsonParser.Event.VALUE_NULL, JsonParser.Event.END_OBJECT),
        OBJECT_OF_EMPTY_ARRAYS((JsonStructure)AbstractJsonValueParserTest.access$100(b -> {
            b.add("a", (JsonValue)JsonValue.EMPTY_JSON_ARRAY);
            b.add("b", (JsonValue)JsonValue.EMPTY_JSON_ARRAY);
        }), JsonParser.Event.START_OBJECT, JsonParser.Event.KEY_NAME, JsonParser.Event.START_ARRAY, JsonParser.Event.END_ARRAY, JsonParser.Event.KEY_NAME, JsonParser.Event.START_ARRAY, JsonParser.Event.END_ARRAY, JsonParser.Event.END_OBJECT),
        OBJECT_OF_EMPTY_OBJECTS((JsonStructure)AbstractJsonValueParserTest.access$100(b -> {
            b.add("a", (JsonValue)JsonValue.EMPTY_JSON_OBJECT);
            b.add("b", (JsonValue)JsonValue.EMPTY_JSON_OBJECT);
        }), JsonParser.Event.START_OBJECT, JsonParser.Event.KEY_NAME, JsonParser.Event.START_OBJECT, JsonParser.Event.END_OBJECT, JsonParser.Event.KEY_NAME, JsonParser.Event.START_OBJECT, JsonParser.Event.END_OBJECT, JsonParser.Event.END_OBJECT),
        OBJECT_OF_ARRAYS((JsonStructure)AbstractJsonValueParserTest.access$100(b -> {
            b.add("a", (JsonValue)AbstractJsonValueParserTest.array(b2 -> b2.add("hello").add(42)));
            b.add("b", (JsonValue)AbstractJsonValueParserTest.array(b2 -> b2.add(true).add(false).addNull()));
        }), JsonParser.Event.START_OBJECT, JsonParser.Event.KEY_NAME, JsonParser.Event.START_ARRAY, JsonParser.Event.VALUE_STRING, JsonParser.Event.VALUE_NUMBER, JsonParser.Event.END_ARRAY, JsonParser.Event.KEY_NAME, JsonParser.Event.START_ARRAY, JsonParser.Event.VALUE_TRUE, JsonParser.Event.VALUE_FALSE, JsonParser.Event.VALUE_NULL, JsonParser.Event.END_ARRAY, JsonParser.Event.END_OBJECT),
        OBJECT_OF_OBJECTS((JsonStructure)AbstractJsonValueParserTest.access$100(b -> {
            b.add("a", (JsonValue)AbstractJsonValueParserTest.object(b2 -> b2.add("a1", "hello").add("a2", 42)));
            b.add("b", (JsonValue)AbstractJsonValueParserTest.object(b2 -> b2.add("b1", true).add("b2", false).addNull("b3")));
        }), JsonParser.Event.START_OBJECT, JsonParser.Event.KEY_NAME, JsonParser.Event.START_OBJECT, JsonParser.Event.KEY_NAME, JsonParser.Event.VALUE_STRING, JsonParser.Event.KEY_NAME, JsonParser.Event.VALUE_NUMBER, JsonParser.Event.END_OBJECT, JsonParser.Event.KEY_NAME, JsonParser.Event.START_OBJECT, JsonParser.Event.KEY_NAME, JsonParser.Event.VALUE_TRUE, JsonParser.Event.KEY_NAME, JsonParser.Event.VALUE_FALSE, JsonParser.Event.KEY_NAME, JsonParser.Event.VALUE_NULL, JsonParser.Event.END_OBJECT, JsonParser.Event.END_OBJECT);

        public final JsonStructure value;
        public final JsonParser.Event[] events;

        private ParserEventTestCase(JsonStructure value, JsonParser.Event ... events) {
            this.value = value;
            this.events = events;
        }
    }
}

