/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.jsonp.testsuite.helper;

import jakarta.json.stream.JsonLocation;
import java.util.Comparator;

public final class JsonLocations {
    public static final Comparator<JsonLocation> COMPARATOR = new Comparator<JsonLocation>(){

        @Override
        public int compare(JsonLocation o1, JsonLocation o2) {
            int result = Long.compare(o1.getLineNumber(), o2.getLineNumber());
            if (result == 0 && (result = Long.compare(o1.getColumnNumber(), o2.getColumnNumber())) == 0) {
                result = Long.compare(o1.getStreamOffset(), o2.getStreamOffset());
            }
            return result;
        }
    };

    public static JsonLocation at(long lineNumber, long columnNumber, long streamOffset) {
        return new JsonLocationImpl(lineNumber, columnNumber, streamOffset);
    }

    private JsonLocations() {
    }

    private static class JsonLocationImpl
    implements JsonLocation {
        private final long lineNmber;
        private final long columnNumber;
        private final long streamOffset;

        JsonLocationImpl(long lineNumber, long columnNumber, long streamOffset) {
            this.lineNmber = lineNumber;
            this.columnNumber = columnNumber;
            this.streamOffset = streamOffset;
        }

        public long getLineNumber() {
            return this.lineNmber;
        }

        public long getColumnNumber() {
            return this.columnNumber;
        }

        public long getStreamOffset() {
            return this.streamOffset;
        }

        public String toString() {
            StringBuilder b = new StringBuilder("[");
            b.append(this.getLineNumber()).append(',');
            b.append(this.getColumnNumber()).append(',');
            b.append(this.getStreamOffset());
            return b.append(']').toString();
        }
    }
}

