/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.jsonp.testsuite.helper;

import org.assertj.core.api.AbstractAssert;

public final class JsonAssertions {
    public static JsonAssertion assertThat(String actual) {
        return new JsonAssertion(actual);
    }

    private JsonAssertions() {
    }

    public static final class JsonAssertion
    extends AbstractAssert<JsonAssertion, String> {
        private JsonAssertion(String actual) {
            super((Object)actual, JsonAssertion.class);
        }

        public JsonAssertion isEqualTo(String expected) {
            this.isNotNull();
            if (!JsonAssertion.normalizeJson((String)this.actual).equals(JsonAssertion.normalizeJson(expected))) {
                this.failWithMessage("Expected JSON to be <%s> but was <%s>", new Object[]{expected, this.actual});
            }
            return this;
        }

        private static String normalizeJson(String json) {
            StringBuilder builder = new StringBuilder();
            int length = json.length();
            block0: for (int i = 0; i < length; ++i) {
                char c = json.charAt(i);
                builder.append(c);
                if (c != '\"') continue;
                while (++i < length) {
                    c = json.charAt(i);
                    builder.append(c);
                    if (c == '\"') continue block0;
                    if (c != '\\' || ++i >= length) continue;
                    c = json.charAt(i);
                    builder.append(c);
                    if (c != 'u') continue;
                    int j = 0;
                    while (j++ < 4 && ++i < length) {
                        c = json.charAt(i);
                        builder.append(JsonAssertion.toUpperHexDigit(c));
                    }
                }
            }
            return builder.toString();
        }

        private static char toUpperHexDigit(char c) {
            if ('a' <= c && c <= 'f') {
                return (char)(65 + (c - 97));
            }
            return c;
        }
    }
}

