/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.jsonp.testsuite.tests;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonValue;
import java.io.InputStream;
import java.util.stream.Stream;

enum TestCaseResource {
    JSON_POINTER("/org/leadpony/jsonp/testsuite/json-pointer.json"),
    JSON_POINTER_ADD("/org/leadpony/jsonp/testsuite/json-pointer-add.json"),
    JSON_POINTER_REMOVE("/org/leadpony/jsonp/testsuite/json-pointer-remove.json"),
    JSON_POINTER_REPLACE("/org/leadpony/jsonp/testsuite/json-pointer-replace.json"),
    JSON_PATCH("/org/leadpony/jsonp/testsuite/json-patch.json"),
    JSON_PATCH_MALFORMED("/org/leadpony/jsonp/testsuite/json-patch-malformed.json"),
    JSON_PATCH_DIFF("/org/leadpony/jsonp/testsuite/json-patch-diff.json"),
    JSON_MERGE_PATCH("/org/leadpony/jsonp/testsuite/json-merge-patch.json"),
    JSON_MERGE_DIFF("/org/leadpony/jsonp/testsuite/json-merge-diff.json"),
    RFC6902_EXAMPLES("/org/ietf/rfc/rfc6902/examples.json"),
    RFC7396_EXAMPLES("/org/ietf/rfc/rfc7396/examples.json");

    private final String name;

    private TestCaseResource(String name) {
        this.name = name;
    }

    Stream<JsonObject> getObjectStream() {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(this.name);
        try (JsonReader reader = Json.createReader((InputStream)in);){
            Stream<JsonObject> stream = reader.readArray().stream().map(JsonValue::asJsonObject);
            return stream;
        }
    }
}

