/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.jsonp.testsuite.tests;

import jakarta.json.Json;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import jakarta.json.stream.JsonGenerationException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Logger;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.leadpony.jsonp.testsuite.helper.LoggerFactory;

public class JsonWriterIllegalStateTest {
    private static final Logger LOG = LoggerFactory.getLogger(JsonWriterIllegalStateTest.class);
    private static JsonWriterFactory factory;
    protected JsonWriter writer;

    @BeforeAll
    public static void setUpOnce() {
        factory = Json.createWriterFactory(null);
    }

    @BeforeEach
    public void setUp() {
        this.writer = factory.createWriter((Writer)new StringWriter());
    }

    @Test
    public void closeShouldThrowJsonGenerationException() {
        Throwable thrown = Assertions.catchThrowable(() -> this.writer.close());
        Assertions.assertThat((Throwable)thrown).isInstanceOf(JsonGenerationException.class);
        LOG.info(thrown.getMessage());
    }

    @Nested
    public class AfterWritingObject
    extends IllegalStateTest {
        @BeforeEach
        public void setUp() {
            JsonWriterIllegalStateTest.this.writer.writeObject(JsonValue.EMPTY_JSON_OBJECT);
        }
    }

    @Nested
    public class AfterWritingArray
    extends IllegalStateTest {
        @BeforeEach
        public void setUp() {
            JsonWriterIllegalStateTest.this.writer.writeArray(JsonValue.EMPTY_JSON_ARRAY);
        }
    }

    @Nested
    public class AfterWritingStructure
    extends IllegalStateTest {
        @BeforeEach
        public void setUp() {
            JsonWriterIllegalStateTest.this.writer.write((JsonStructure)JsonValue.EMPTY_JSON_ARRAY);
        }
    }

    @Nested
    public class AfterWritingValue
    extends IllegalStateTest {
        @BeforeEach
        public void setUp() {
            JsonWriterIllegalStateTest.this.writer.write(JsonValue.TRUE);
        }
    }

    @Nested
    public class AfterClosing
    extends IllegalStateTest {
        @BeforeEach
        public void setUp() {
            JsonWriterIllegalStateTest.this.writer.write(JsonValue.TRUE);
            JsonWriterIllegalStateTest.this.writer.close();
        }
    }

    abstract class IllegalStateTest {
        IllegalStateTest() {
        }

        @Test
        public void writeValueShouldThrowIllegalStateException() {
            Throwable thrown = Assertions.catchThrowable(() -> JsonWriterIllegalStateTest.this.writer.write(JsonValue.TRUE));
            Assertions.assertThat((Throwable)thrown).isInstanceOf(IllegalStateException.class);
            LOG.info(thrown.getMessage());
        }

        @Test
        public void writeStructureShouldThrowIllegalStateException() {
            Throwable thrown = Assertions.catchThrowable(() -> JsonWriterIllegalStateTest.this.writer.write((JsonStructure)JsonValue.EMPTY_JSON_ARRAY));
            Assertions.assertThat((Throwable)thrown).isInstanceOf(IllegalStateException.class);
            LOG.info(thrown.getMessage());
        }

        @Test
        public void writeArrayShouldThrowIllegalStateException() {
            Throwable thrown = Assertions.catchThrowable(() -> JsonWriterIllegalStateTest.this.writer.writeArray(JsonValue.EMPTY_JSON_ARRAY));
            Assertions.assertThat((Throwable)thrown).isInstanceOf(IllegalStateException.class);
            LOG.info(thrown.getMessage());
        }

        @Test
        public void writeObjectShouldThrowIllegalStateException() {
            Throwable thrown = Assertions.catchThrowable(() -> JsonWriterIllegalStateTest.this.writer.writeObject(JsonValue.EMPTY_JSON_OBJECT));
            Assertions.assertThat((Throwable)thrown).isInstanceOf(IllegalStateException.class);
            LOG.info(thrown.getMessage());
        }
    }
}

