/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.jsonp.testsuite.tests;

import jakarta.json.Json;
import jakarta.json.JsonException;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Logger;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.leadpony.jsonp.testsuite.helper.LoggerFactory;
import org.leadpony.jsonp.testsuite.helper.Writers;

public class JsonWriterIOExceptionTest {
    private static final Logger LOG = LoggerFactory.getLogger(JsonWriterIOExceptionTest.class);
    private static JsonWriterFactory factory;

    @BeforeAll
    public static void setUpOnce() {
        factory = Json.createWriterFactory(null);
    }

    @Test
    public void writeArrayShouldThrowJsonException() {
        Writer writer = Writers.throwingWhenWriting(new StringWriter());
        JsonWriter jsonWriter = factory.createWriter(writer);
        Throwable thrown = Assertions.catchThrowable(() -> jsonWriter.writeArray(JsonValue.EMPTY_JSON_ARRAY));
        Assertions.assertThat((Throwable)thrown).isInstanceOf(JsonException.class);
        LOG.info(thrown.getMessage());
    }

    @Test
    public void writeObjectShouldThrowJsonException() {
        Writer writer = Writers.throwingWhenWriting(new StringWriter());
        JsonWriter jsonWriter = factory.createWriter(writer);
        Throwable thrown = Assertions.catchThrowable(() -> jsonWriter.writeObject(JsonValue.EMPTY_JSON_OBJECT));
        Assertions.assertThat((Throwable)thrown).isInstanceOf(JsonException.class);
        LOG.info(thrown.getMessage());
    }

    @Test
    public void writeStructureShouldThrowJsonException() {
        Writer writer = Writers.throwingWhenWriting(new StringWriter());
        JsonWriter jsonWriter = factory.createWriter(writer);
        Throwable thrown = Assertions.catchThrowable(() -> jsonWriter.write((JsonStructure)JsonValue.EMPTY_JSON_ARRAY));
        Assertions.assertThat((Throwable)thrown).isInstanceOf(JsonException.class);
        LOG.info(thrown.getMessage());
    }

    @Test
    public void writeValueShouldThrowJsonException() {
        Writer writer = Writers.throwingWhenWriting(new StringWriter());
        JsonWriter jsonWriter = factory.createWriter(writer);
        Throwable thrown = Assertions.catchThrowable(() -> jsonWriter.write(JsonValue.TRUE));
        Assertions.assertThat((Throwable)thrown).isInstanceOf(JsonException.class);
        LOG.info(thrown.getMessage());
    }

    @Test
    public void closeShouldThrowJsonException() {
        Writer writer = Writers.throwingWhenClosing(new StringWriter());
        JsonWriter jsonWriter = factory.createWriter(writer);
        Assertions.assertThatCode(() -> jsonWriter.write(JsonValue.TRUE)).doesNotThrowAnyException();
        Throwable thrown = Assertions.catchThrowable(() -> jsonWriter.close());
        Assertions.assertThat((Throwable)thrown).isInstanceOf(JsonException.class);
        LOG.info(thrown.getMessage());
    }
}

