/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.jsonp.testsuite.tests;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.math.BigDecimal;
import java.util.function.Consumer;
import java.util.stream.Stream;

enum JsonValueTestCase {
    TRUE(JsonValue.TRUE, "true"),
    FALSE(JsonValue.FALSE, "false"),
    NULL(JsonValue.NULL, "null"),
    EMPTY_STRING("", "\"\""),
    BLANK_STRING(" ", "\" \""),
    STRING_WORD("hello", "\"hello\""),
    STRING_CONTAINING_SPACE("hello world", "\"hello world\""),
    STRING_CONTAINING_QUOTATION("hello\"world", "\"hello\\\"world\""),
    STRING_CONTAINING_REVERSE_SOLIDUS("hello\\world", "\"hello\\\\world\""),
    STRING_CONTAINING_BACKSPACE("hello\bworld", "\"hello\\bworld\""),
    STRING_CONTAINING_FF("hello\fworld", "\"hello\\fworld\""),
    STRING_CONTAINING_LF("hello\nworld", "\"hello\\nworld\""),
    STRING_CONTAINING_CR("hello\rworld", "\"hello\\rworld\""),
    STRING_CONTAINING_TAB("hello\tworld", "\"hello\\tworld\""),
    STRING_CONTAINING_NULL("hello\u0000world", "\"hello\\u0000world\""),
    STRING_CONTAINING_VT("hello\u000bworld", "\"hello\\u000bworld\""),
    STRING_CONTAINING_ESC("hello\u001bworld", "\"hello\\u001bworld\""),
    G_CLEF("\ud834\udd1e", "\"\ud834\udd1e\""),
    ZERO(0, "0"),
    ONE(1, "1"),
    MINUS_ONE(-1, "-1"),
    TEN(10, "10"),
    MINUS_TEN(-10, "-10"),
    HUNDRED(100, "100"),
    MINUS_HUNDRED(-100, "-100"),
    THOUSAND(1000, "1000"),
    MINUS_THOUSAND(1000, "1000"),
    HOURS_PER_DAY(24, "24"),
    MINUS_HOURS_PER_DAY(-24, "-24"),
    DAYS_PER_YEAR(365, "365"),
    MINUS_DAYS_PER_YEAR(-365, "-365"),
    MAX_INTEGER(Integer.MAX_VALUE, "2147483647"),
    MIN_INTEGER(Integer.MIN_VALUE, "-2147483648"),
    MAX_LONG(Long.MAX_VALUE, "9223372036854775807"),
    MIN_LONG(Long.MIN_VALUE, "-9223372036854775808"),
    BASE_OF_NATURAL_LOGARITHM(new BigDecimal("2.718281828459045"), "2.718281828459045"),
    PI(new BigDecimal("3.141592653589793"), "3.141592653589793"),
    MINUS_PI(new BigDecimal("-3.141592653589793"), "-3.141592653589793"),
    EMPTY_ARRAY((JsonValue)JsonValue.EMPTY_JSON_ARRAY, "[]"),
    ARRAY_OF_INTEGER((JsonValue)JsonValueTestCase.array(b -> b.add(42)), "[42]"),
    ARRAY_OF_INTEGERS((JsonValue)JsonValueTestCase.array(b -> b.add(1).add(2).add(4)), "[1,2,4]"),
    ARRAY_OF_STRING((JsonValue)JsonValueTestCase.array(b -> b.add("hello")), "[\"hello\"]"),
    ARRAY_OF_STRINGS((JsonValue)JsonValueTestCase.array(b -> b.add("hello").add("world")), "[\"hello\",\"world\"]"),
    ARRAY_OF_TRUE((JsonValue)JsonValueTestCase.array(b -> b.add(true)), "[true]"),
    ARRAY_OF_FALSE((JsonValue)JsonValueTestCase.array(b -> b.add(false)), "[false]"),
    ARRAY_OF_BOOLEANS((JsonValue)JsonValueTestCase.array(b -> b.add(true).add(false)), "[true,false]"),
    ARRAY_OF_NULL((JsonValue)JsonValueTestCase.array(b -> b.addNull()), "[null]"),
    ARRAY_OF_NULLS((JsonValue)JsonValueTestCase.array(b -> b.addNull().addNull()), "[null,null]"),
    ARRAY_OF_ARRAY((JsonValue)JsonValueTestCase.array(b -> b.add((JsonValue)JsonValueTestCase.array(b2 -> b2.add(1).add(2).add(3)))), "[[1,2,3]]"),
    ARRAY_OF_EMPTY_ARRAY((JsonValue)JsonValueTestCase.array(b -> b.add((JsonValue)JsonValue.EMPTY_JSON_ARRAY)), "[[]]"),
    ARRAY_OF_EMPTY_OBJECT((JsonValue)JsonValueTestCase.array(b -> b.add((JsonValue)JsonValue.EMPTY_JSON_OBJECT)), "[{}]"),
    ARRAY_OF_ARRAYS((JsonValue)JsonValueTestCase.array(b -> {
        b.add((JsonValue)JsonValueTestCase.array(b2 -> b2.add(1).add(2).add(3)));
        b.add((JsonValue)JsonValueTestCase.array(b2 -> b2.add(4).add(5).add(6)));
    }), "[[1,2,3],[4,5,6]]"),
    ARRAY_OF_EMPTY_ARRAYS((JsonValue)JsonValueTestCase.array(b -> {
        b.add((JsonValue)JsonValue.EMPTY_JSON_ARRAY);
        b.add((JsonValue)JsonValue.EMPTY_JSON_ARRAY);
    }), "[[],[]]"),
    ARRAY_OF_EMPTY_OBJECTS((JsonValue)JsonValueTestCase.array(b -> {
        b.add((JsonValue)JsonValue.EMPTY_JSON_OBJECT);
        b.add((JsonValue)JsonValue.EMPTY_JSON_OBJECT);
    }), "[{},{}]"),
    EMPTY_OBJECT((JsonValue)JsonValue.EMPTY_JSON_OBJECT, "{}"),
    OBJECT_OF_INTEGERS((JsonValue)JsonValueTestCase.object(b -> {
        b.add("a", 1);
        b.add("b", 2);
    }), "{\"a\":1,\"b\":2}"),
    OBJECT_OF_STRING((JsonValue)JsonValueTestCase.object(b -> {
        b.add("a", "hello");
        b.add("b", "world");
    }), "{\"a\":\"hello\",\"b\":\"world\"}"),
    OBJECT_OF_ARRAYS((JsonValue)JsonValueTestCase.object(b -> {
        b.add("a", (JsonValue)JsonValueTestCase.array(b2 -> b2.add(1).add(2)));
        b.add("b", (JsonValue)JsonValueTestCase.array(b2 -> b2.add(3).add(4)));
    }), "{\"a\":[1,2],\"b\":[3,4]}"),
    OBJECT_OF_EMPTY_ARRAYS((JsonValue)JsonValueTestCase.object(b -> {
        b.add("a", (JsonValue)JsonValue.EMPTY_JSON_ARRAY);
        b.add("b", (JsonValue)JsonValue.EMPTY_JSON_ARRAY);
    }), "{\"a\":[],\"b\":[]}"),
    OBJECT_OF_OBJECTS((JsonValue)JsonValueTestCase.object(b -> {
        b.add("a", (JsonValue)JsonValueTestCase.object(b2 -> {
            b2.add("a1", 1);
            b2.add("a2", 2);
        }));
        b.add("b", (JsonValue)JsonValueTestCase.object(b2 -> {
            b2.add("b1", 3);
            b2.add("b2", 4);
        }));
    }), "{\"a\":{\"a1\":1,\"a2\":2},\"b\":{\"b1\":3,\"b2\":4}}"),
    OBJECT_OF_EMPTY_OBJECTS((JsonValue)JsonValueTestCase.object(b -> {
        b.add("a", (JsonValue)JsonValue.EMPTY_JSON_OBJECT);
        b.add("b", (JsonValue)JsonValue.EMPTY_JSON_OBJECT);
    }), "{\"a\":{},\"b\":{}}");

    private final JsonValue value;
    private final String string;
    private static JsonBuilderFactory builderFactory;

    private JsonValueTestCase(JsonValue value, String string2) {
        this.value = value;
        this.string = string2;
    }

    private JsonValueTestCase(String value, String string2) {
        this((JsonValue)Json.createValue((String)value), string2);
    }

    private JsonValueTestCase(int value, String string2) {
        this((JsonValue)Json.createValue((int)value), string2);
    }

    private JsonValueTestCase(long value, String string2) {
        this((JsonValue)Json.createValue((long)value), string2);
    }

    private JsonValueTestCase(BigDecimal value, String string2) {
        this((JsonValue)Json.createValue((BigDecimal)value), string2);
    }

    JsonValue getJsonValue() {
        return this.value;
    }

    String getString() {
        return this.string;
    }

    JsonValue.ValueType getType() {
        return this.value.getValueType();
    }

    boolean isString() {
        return this.getType() == JsonValue.ValueType.STRING;
    }

    boolean isArray() {
        return this.getType() == JsonValue.ValueType.ARRAY;
    }

    boolean isObject() {
        return this.getType() == JsonValue.ValueType.OBJECT;
    }

    boolean isStructure() {
        return this.isArray() || this.isObject();
    }

    public static Stream<JsonValueTestCase> getArraysAsStream() {
        return Stream.of(JsonValueTestCase.values()).filter(JsonValueTestCase::isArray);
    }

    public static Stream<JsonValueTestCase> getObjectsAsStream() {
        return Stream.of(JsonValueTestCase.values()).filter(JsonValueTestCase::isObject);
    }

    public static Stream<JsonValueTestCase> getStructuresAsStream() {
        return Stream.of(JsonValueTestCase.values()).filter(JsonValueTestCase::isStructure);
    }

    public static Stream<JsonValueTestCase> getStringsAsStream() {
        return Stream.of(JsonValueTestCase.values()).filter(JsonValueTestCase::isString);
    }

    private static JsonArray array(Consumer<JsonArrayBuilder> consumer) {
        JsonArrayBuilder builder = JsonValueTestCase.getBuilderFactory().createArrayBuilder();
        consumer.accept(builder);
        return builder.build();
    }

    private static JsonObject object(Consumer<JsonObjectBuilder> consumer) {
        JsonObjectBuilder builder = JsonValueTestCase.getBuilderFactory().createObjectBuilder();
        consumer.accept(builder);
        return builder.build();
    }

    private static JsonBuilderFactory getBuilderFactory() {
        if (builderFactory == null) {
            builderFactory = Json.createBuilderFactory(null);
        }
        return builderFactory;
    }
}

