/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.jsonp.testsuite.tests;

import jakarta.json.Json;
import jakarta.json.JsonValue;
import java.math.BigDecimal;
import org.leadpony.jsonp.testsuite.helper.JsonSupplier;
import org.leadpony.jsonp.testsuite.tests.JsonValueTestCase;

enum JsonTestCase implements JsonSupplier
{
    TRUE,
    FALSE,
    NULL,
    EMPTY_STRING,
    BLANK_STRING,
    STRING_WORD,
    STRING_CONTAINING_SPACE,
    ZERO,
    MINUS_ZERO("-0", JsonTestCase.ZERO.value),
    ONE,
    MINUS_ONE,
    TEN,
    MINUS_TEN,
    HUNDRED,
    MINUS_HUNDRED,
    THOUSAND,
    MINUS_THOUSAND,
    HOURS_PER_DAY,
    MINUS_HOURS_PER_DAY,
    DAYS_PER_YEAR,
    MINUS_DAYS_PER_YEAR,
    MAX_INTEGER,
    MIN_INTEGER,
    MAX_LONG,
    MIN_LONG,
    BASE_OF_NATURAL_LOGARITHM,
    PI,
    MINUS_PI,
    HUNDRED_SCIENTIFIC_NOTATION("1e+2", new BigDecimal("1E+2")),
    HUNDRED_SCIENTIFIC_NOTATION_CAPITAL("1E+2", JsonTestCase.HUNDRED_SCIENTIFIC_NOTATION.value),
    HUNDREDTH_SCIENTIFIC_NOTATION_MINUS("1e-2", new BigDecimal("1E-2")),
    HUNDREDTH_NOTATION_CAPITAL_MINNUS("1E-2", JsonTestCase.HUNDREDTH_SCIENTIFIC_NOTATION_MINUS.value);

    private final String json;
    private final JsonValue value;

    private JsonTestCase() {
        JsonValueTestCase testCase = JsonValueTestCase.valueOf(this.name());
        this.json = testCase.getString();
        this.value = testCase.getJsonValue();
    }

    private JsonTestCase(String json, JsonValue value) {
        this.json = json;
        this.value = value;
    }

    private JsonTestCase(String json, BigDecimal value) {
        this.json = json;
        this.value = Json.createValue((BigDecimal)value);
    }

    @Override
    public String getJson() {
        return this.json;
    }

    @Override
    public JsonValue getValue() {
        return this.value;
    }
}

