/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.jsonp.testsuite.tests;

import jakarta.json.JsonValue;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum JsonResource {
    GLOSSARY("/org/json/example/glossary.json", JsonValue.ValueType.OBJECT),
    MENU("/org/json/example/menu.json", JsonValue.ValueType.OBJECT),
    MENU2("/org/json/example/menu2.json", JsonValue.ValueType.OBJECT),
    WEB_APP("/org/json/example/web-app.json", JsonValue.ValueType.OBJECT),
    WIDGET("/org/json/example/widget.json", JsonValue.ValueType.OBJECT),
    IMAGE("/org/ietf/rfc/rfc7159/image.json", JsonValue.ValueType.OBJECT),
    ZIP("/org/ietf/rfc/rfc7159/zip.json", JsonValue.ValueType.ARRAY),
    ATOM_API("/com/github/atom-api.json", JsonValue.ValueType.OBJECT);

    private final String name;
    private final JsonValue.ValueType type;
    private final Charset charset;

    private JsonResource(String name, JsonValue.ValueType type) {
        this(name, type, StandardCharsets.UTF_8);
    }

    private JsonResource(String name, JsonValue.ValueType type, Charset charset) {
        this.name = name;
        this.type = type;
        this.charset = charset;
    }

    public InputStream openStream() {
        return ((Object)((Object)this)).getClass().getResourceAsStream(this.name);
    }

    public Reader createReader() {
        return new InputStreamReader(this.openStream(), this.getCharset());
    }

    public JsonValue.ValueType getType() {
        return this.type;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public boolean isArray() {
        return this.type == JsonValue.ValueType.ARRAY;
    }

    public boolean isObject() {
        return this.type == JsonValue.ValueType.OBJECT;
    }

    public boolean isStructure() {
        return this.type == JsonValue.ValueType.ARRAY || this.type == JsonValue.ValueType.OBJECT;
    }

    public String getJsonAsString() {
        return this.getResourceAsString(this.name);
    }

    public String getJsonIndentedWithTabAsString() {
        String name = this.getNameWithoutExtension() + ".tab.json";
        return this.getResourceAsString(name);
    }

    public String getJsonIndentedWithSpacesAsString(int spaces) {
        String name = this.getNameWithoutExtension() + ".sp" + spaces + ".json";
        return this.getResourceAsString(name);
    }

    public String getMinifiedJsonAsString() {
        String name = this.getNameWithoutExtension() + ".min.json";
        return this.getResourceAsString(name);
    }

    public static Stream<JsonResource> getArraysAsStream() {
        return Stream.of(JsonResource.values()).filter(JsonResource::isArray);
    }

    public static Stream<JsonResource> getObjectsAsStream() {
        return Stream.of(JsonResource.values()).filter(JsonResource::isObject);
    }

    public static Stream<JsonResource> getStructuresAsStream() {
        return Stream.of(JsonResource.values()).filter(JsonResource::isStructure);
    }

    private String getNameWithoutExtension() {
        return this.name.substring(0, this.name.lastIndexOf(46));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getResourceAsString(String name) {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(name);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            String string = reader.lines().collect(Collectors.joining("\n"));
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }
}

