/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.jsonp.testsuite.tests;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonLocation;
import jakarta.json.stream.JsonParsingException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.leadpony.jsonp.testsuite.annotation.Ambiguous;
import org.leadpony.jsonp.testsuite.helper.LoggerFactory;
import org.leadpony.jsonp.testsuite.tests.IllFormedJsonTestCase;
import org.leadpony.jsonp.testsuite.tests.JsonResource;

public class JsonReaderTest {
    private static final Logger LOG = LoggerFactory.getLogger(JsonReaderTest.class);
    private static JsonReaderFactory factory;

    @BeforeAll
    public static void setUpOnce() {
        factory = Json.createReaderFactory(null);
    }

    @Test
    public void readArrayShouldReadEmptyArray() {
        String json = "[]";
        JsonReader reader = factory.createReader((Reader)new StringReader(json));
        JsonArray actual = reader.readArray();
        reader.close();
        Assertions.assertThat((boolean)actual.isEmpty());
    }

    @Test
    public void readArrayShouldReadSimpleArray() {
        String json = "[true,false,null,365,\"hello\"]";
        JsonReader reader = factory.createReader((Reader)new StringReader(json));
        JsonArray actual = reader.readArray();
        reader.close();
        Assertions.assertThat((List)actual).containsExactly((Object[])new JsonValue[]{JsonValue.TRUE, JsonValue.FALSE, JsonValue.NULL, Json.createValue((int)365), Json.createValue((String)"hello")});
    }

    @ParameterizedTest
    @MethodSource(value={"org.leadpony.jsonp.testsuite.tests.JsonResource#getArraysAsStream"})
    public void readArrayShouldReadArrayAsExpected(JsonResource resource) {
        JsonArray actual;
        try (JsonReader reader = factory.createReader(resource.createReader());){
            actual = reader.readArray();
        }
        Assertions.assertThat((List)actual).isNotNull();
        Assertions.assertThat((String)actual.toString()).isEqualTo(resource.getMinifiedJsonAsString());
    }

    @ParameterizedTest
    @ValueSource(strings={"{}", "\"hello\"", "42", "true", "false", "null"})
    public void readArrayShouldThrowJsonParsingException(String json) {
        JsonReader reader = factory.createReader((Reader)new StringReader(json));
        Throwable thrown = Assertions.catchThrowable(() -> reader.readArray());
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)thrown).isNotNull()).isInstanceOf(JsonParsingException.class);
    }

    @ParameterizedTest
    @ValueSource(strings={"[1,2],3", "[1,2][3,4]"})
    @Ambiguous
    public void readArrayShouldReadArrayIgnoringGarbage(String json) {
        JsonReader reader = factory.createReader((Reader)new StringReader(json));
        JsonArray array = reader.readArray();
        Assertions.assertThat((List)array).isNotNull();
    }

    @Test
    public void readObjectShouldReadEmptyObject() {
        String json = "{}";
        JsonReader reader = factory.createReader((Reader)new StringReader(json));
        JsonObject actual = reader.readObject();
        reader.close();
        Assertions.assertThat((boolean)actual.isEmpty());
    }

    @Test
    public void readObjectShouldReadSimpleObject() {
        String json = "{\"a\":true,\"b\":false,\"c\":null,\"d\":365,\"e\":\"hello\"}";
        HashMap<String, Object> expected = new HashMap<String, Object>();
        expected.put("a", JsonValue.TRUE);
        expected.put("b", JsonValue.FALSE);
        expected.put("c", JsonValue.NULL);
        expected.put("d", Json.createValue((int)365));
        expected.put("e", Json.createValue((String)"hello"));
        JsonReader reader = factory.createReader((Reader)new StringReader(json));
        JsonObject actual = reader.readObject();
        reader.close();
        ((MapAssert)Assertions.assertThat((Map)actual).hasSameSizeAs(expected)).containsAllEntriesOf(expected);
    }

    @ParameterizedTest
    @MethodSource(value={"org.leadpony.jsonp.testsuite.tests.JsonResource#getObjectsAsStream"})
    public void readObjectShouldReadObjectAsExpected(JsonResource resource) {
        JsonObject actual;
        try (JsonReader reader = factory.createReader(resource.createReader());){
            actual = reader.readObject();
        }
        Assertions.assertThat((Map)actual).isNotNull();
        Assertions.assertThat((String)actual.toString()).isEqualTo(resource.getMinifiedJsonAsString());
    }

    @ParameterizedTest
    @ValueSource(strings={"[]", "\"hello\"", "42", "true", "false", "null"})
    public void readObjectShouldThrowJsonParsingException(String json) {
        JsonReader reader = factory.createReader((Reader)new StringReader(json));
        Throwable thrown = Assertions.catchThrowable(() -> reader.readObject());
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)thrown).isNotNull()).isInstanceOf(JsonParsingException.class);
    }

    @ParameterizedTest
    @ValueSource(strings={"{\"a\":1},2", "{\"a\":1}{\"b\":2}"})
    @Ambiguous
    public void readObjectShouldReadObjectIgnoringGarbage(String json) {
        JsonReader reader = factory.createReader((Reader)new StringReader(json));
        JsonObject object = reader.readObject();
        Assertions.assertThat((Map)object).isNotNull();
    }

    @ParameterizedTest
    @MethodSource(value={"org.leadpony.jsonp.testsuite.tests.JsonResource#getStructuresAsStream"})
    public void readShouldReadStructureAsExpected(JsonResource resource) {
        JsonStructure actual;
        try (JsonReader reader = factory.createReader(resource.createReader());){
            actual = reader.read();
        }
        Assertions.assertThat((Object)actual).isNotNull();
        Assertions.assertThat((String)actual.toString()).isEqualTo(resource.getMinifiedJsonAsString());
    }

    @ParameterizedTest
    @ValueSource(strings={"\"hello\"", "42", "true", "false", "null"})
    public void readShouldThrowJsonParsingException(String json) {
        JsonReader reader = factory.createReader((Reader)new StringReader(json));
        Throwable thrown = Assertions.catchThrowable(() -> reader.read());
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)thrown).isNotNull()).isInstanceOf(JsonParsingException.class);
    }

    @Test
    public void readShouldThrowJsonParsingExceptionIfInputIsEmptyReader() {
        String json = "";
        JsonReader reader = factory.createReader((Reader)new StringReader(json));
        Throwable thrown = Assertions.catchThrowable(() -> reader.read());
        LOG.info(thrown.getMessage());
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)thrown).isNotNull()).isInstanceOf(JsonParsingException.class);
    }

    @ParameterizedTest
    @EnumSource(value=JsonResource.class)
    public void readValueShouldReadValueAsExpected(JsonResource resource) {
        JsonValue actual;
        try (JsonReader reader = factory.createReader(resource.createReader());){
            actual = reader.readValue();
        }
        Assertions.assertThat((Object)actual).isNotNull();
        Assertions.assertThat((Comparable)actual.getValueType()).isEqualTo((Object)resource.getType());
        Assertions.assertThat((String)actual.toString()).isEqualTo(resource.getMinifiedJsonAsString());
    }

    @ParameterizedTest
    @EnumSource(value=IllFormedJsonTestCase.class)
    public void readValueShouldThrowExceptionIfIllFormed(IllFormedJsonTestCase test) {
        Throwable thrown = Assertions.catchThrowable(() -> {
            try (JsonReader reader = factory.createReader((Reader)new StringReader(test.getJson()));){
                reader.readValue();
            }
        });
        LOG.info(test.toString());
        LOG.info(thrown.getMessage());
        Assertions.assertThat((Throwable)thrown).isInstanceOf(JsonParsingException.class);
        JsonParsingException actual = (JsonParsingException)thrown;
        JsonLocation location = actual.getLocation();
        Assertions.assertThat((long)location.getLineNumber()).isEqualTo(test.getLineNumber());
        Assertions.assertThat((long)location.getColumnNumber()).isEqualTo(test.getColumnNumber());
        Assertions.assertThat((long)location.getStreamOffset()).isEqualTo(test.getStreamOffset());
    }

    @ParameterizedTest
    @ValueSource(strings={"1 2", "\"hello\" \"world\"", "true false"})
    @Ambiguous
    public void readValueShouldReadValueIgnoringGarbage(String json) {
        JsonReader reader = factory.createReader((Reader)new StringReader(json));
        JsonValue value = reader.readValue();
        Assertions.assertThat((Object)value).isNotNull();
    }
}

