/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.jsonp.testsuite.tests;

import jakarta.json.Json;
import jakarta.json.JsonException;
import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import java.io.Reader;
import java.io.StringReader;
import java.util.logging.Logger;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.leadpony.jsonp.testsuite.helper.LoggerFactory;
import org.leadpony.jsonp.testsuite.helper.Readers;

public class JsonReaderIOExceptionTest {
    private static final Logger LOG = LoggerFactory.getLogger(JsonReaderIOExceptionTest.class);
    private static JsonReaderFactory factory;

    @BeforeAll
    public static void setUpOnce() {
        factory = Json.createReaderFactory(null);
    }

    @Test
    public void readArrayShouldThrowJsonException() {
        Reader reader = Readers.throwingWhenReading(new StringReader("[]"));
        JsonReader jsonReader = factory.createReader(reader);
        Throwable thrown = Assertions.catchThrowable(() -> jsonReader.readArray());
        Assertions.assertThat((Throwable)thrown).isInstanceOf(JsonException.class);
        LOG.info(thrown.getMessage());
    }

    @Test
    public void readObjectShouldThrowJsonException() {
        Reader reader = Readers.throwingWhenReading(new StringReader("{}"));
        JsonReader jsonReader = factory.createReader(reader);
        Throwable thrown = Assertions.catchThrowable(() -> jsonReader.readObject());
        Assertions.assertThat((Throwable)thrown).isInstanceOf(JsonException.class);
        LOG.info(thrown.getMessage());
    }

    @Test
    public void readShouldThrowJsonException() {
        Reader reader = Readers.throwingWhenReading(new StringReader("{}"));
        JsonReader jsonReader = factory.createReader(reader);
        Throwable thrown = Assertions.catchThrowable(() -> jsonReader.read());
        Assertions.assertThat((Throwable)thrown).isInstanceOf(JsonException.class);
        LOG.info(thrown.getMessage());
    }

    @Test
    public void readValueShouldThrowJsonException() {
        Reader reader = Readers.throwingWhenReading(new StringReader("true"));
        JsonReader jsonReader = factory.createReader(reader);
        Throwable thrown = Assertions.catchThrowable(() -> jsonReader.readValue());
        Assertions.assertThat((Throwable)thrown).isInstanceOf(JsonException.class);
        LOG.info(thrown.getMessage());
    }

    @Test
    public void closeShouldThrowJsonException() {
        Reader reader = Readers.throwingWhenClosing(new StringReader("{}"));
        JsonReader jsonReader = factory.createReader(reader);
        Throwable thrown = Assertions.catchThrowable(() -> jsonReader.close());
        Assertions.assertThat((Throwable)thrown).isInstanceOf(JsonException.class);
        LOG.info(thrown.getMessage());
    }
}

