/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.jsonp.testsuite.tests;

import jakarta.json.Json;
import jakarta.json.JsonException;
import jakarta.json.JsonPointer;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.leadpony.jsonp.testsuite.helper.LoggerFactory;
import org.leadpony.jsonp.testsuite.tests.TestCaseResource;

public class JsonPointerTest {
    private static final Logger LOG = LoggerFactory.getLogger(JsonPointerTest.class);

    @ParameterizedTest
    @EnumSource(value=JsonPointerTestCase.class)
    public void createPointerShouldCreateJsonPointerAsExpeced(JsonPointerTestCase test) {
        Throwable thrown = Assertions.catchThrowable(() -> {
            JsonPointer pointer = Json.createPointer((String)test.pointer);
            Assertions.assertThat((Object)pointer).isNotNull();
        });
        if (test.valid) {
            Assertions.assertThat((Throwable)thrown).isNull();
        } else {
            ((AbstractThrowableAssert)Assertions.assertThat((Throwable)thrown).isNotNull()).isInstanceOf(JsonException.class);
            LOG.info(thrown.getMessage());
        }
    }

    public static Stream<AddOrReplaceTestCase> getAddOrReplaceTestCases(TestCaseResource resource) {
        return resource.getObjectStream().flatMap(object -> {
            JsonStructure json = (JsonStructure)object.get((Object)"json");
            return object.getJsonArray("tests").stream().map(JsonValue::asJsonObject).map(test -> {
                String pointer = test.getString("pointer");
                JsonValue value = (JsonValue)test.get((Object)"value");
                JsonValue result = (JsonValue)test.get((Object)"result");
                return new AddOrReplaceTestCase(json, pointer, value, result);
            });
        });
    }

    public static Stream<AddOrReplaceTestCase> addShouldAddValueAsExpeced() {
        return JsonPointerTest.getAddOrReplaceTestCases(TestCaseResource.JSON_POINTER_ADD);
    }

    @ParameterizedTest
    @MethodSource
    public void addShouldAddValueAsExpeced(AddOrReplaceTestCase test) {
        JsonPointer pointer = Json.createPointer((String)test.pointer);
        if (test.result != null) {
            JsonStructure actual = pointer.add(test.json, test.value);
            Assertions.assertThat((Object)actual).isEqualTo((Object)test.result);
        } else {
            Throwable thrown = Assertions.catchThrowable(() -> pointer.add(test.json, test.value));
            Assertions.assertThat((Throwable)thrown).isInstanceOf(JsonException.class);
            LOG.info(thrown.getMessage());
        }
    }

    public static Stream<AddOrReplaceTestCase> replaceShouldReplaceValueAsExpeced() {
        return JsonPointerTest.getAddOrReplaceTestCases(TestCaseResource.JSON_POINTER_REPLACE);
    }

    @ParameterizedTest
    @MethodSource
    public void replaceShouldReplaceValueAsExpeced(AddOrReplaceTestCase test) {
        JsonPointer pointer = Json.createPointer((String)test.pointer);
        if (test.result != null) {
            JsonStructure actual = pointer.replace(test.json, test.value);
            Assertions.assertThat((Object)actual).isEqualTo((Object)test.result);
        } else {
            Throwable thrown = Assertions.catchThrowable(() -> pointer.replace(test.json, test.value));
            Assertions.assertThat((Throwable)thrown).isInstanceOf(JsonException.class);
            LOG.info(thrown.getMessage());
        }
    }

    public static Stream<RemovalTestCase> removeShouldRemoveValueAsExpeced() {
        return TestCaseResource.JSON_POINTER_REMOVE.getObjectStream().flatMap(object -> {
            JsonStructure json = (JsonStructure)object.get((Object)"json");
            return object.getJsonArray("tests").stream().map(JsonValue::asJsonObject).map(test -> {
                String pointer = test.getString("pointer");
                JsonValue result = (JsonValue)test.get((Object)"result");
                return new RemovalTestCase(json, pointer, result);
            });
        });
    }

    @ParameterizedTest
    @MethodSource
    public void removeShouldRemoveValueAsExpeced(RemovalTestCase test) {
        JsonPointer pointer = Json.createPointer((String)test.pointer);
        if (test.result != null) {
            JsonStructure actual = pointer.remove(test.json);
            Assertions.assertThat((Object)actual).isEqualTo((Object)test.result);
        } else {
            Throwable thrown = Assertions.catchThrowable(() -> pointer.remove(test.json));
            Assertions.assertThat((Throwable)thrown).isInstanceOf(JsonException.class);
            LOG.info(thrown.getMessage());
        }
    }

    public static Stream<EvaluationTestCase> containsValueShouldReturnTrueAsExpeced() {
        return TestCaseResource.JSON_POINTER.getObjectStream().flatMap(object -> {
            JsonStructure json = (JsonStructure)object.get((Object)"json");
            return object.getJsonArray("tests").stream().map(JsonValue::asJsonObject).map(test -> {
                String pointer = test.getString("pointer");
                JsonValue value = (JsonValue)test.get((Object)"value");
                return new EvaluationTestCase(json, pointer, value);
            });
        });
    }

    @ParameterizedTest
    @MethodSource
    public void containsValueShouldReturnTrueAsExpeced(EvaluationTestCase test) {
        JsonPointer pointer = Json.createPointer((String)test.pointer);
        Assertions.assertThatCode(() -> {
            boolean actual = pointer.containsValue(test.json);
            Assertions.assertThat((boolean)actual).isEqualTo(test.value != null);
        }).doesNotThrowAnyException();
    }

    @ParameterizedTest
    @MethodSource(value={"containsValueShouldReturnTrueAsExpeced"})
    public void getValueShouldReturnValueAsExpeced(EvaluationTestCase test) {
        JsonPointer pointer = Json.createPointer((String)test.pointer);
        if (test.value != null) {
            JsonValue actual = pointer.getValue(test.json);
            ((ObjectAssert)Assertions.assertThat((Object)actual).isNotNull()).isEqualTo((Object)test.value);
        } else {
            Throwable thrown = Assertions.catchThrowable(() -> pointer.getValue(test.json));
            Assertions.assertThat((Throwable)thrown).isInstanceOf(JsonException.class);
            LOG.info(thrown.getMessage());
        }
    }

    static class EvaluationTestCase {
        final JsonStructure json;
        final String pointer;
        final JsonValue value;

        EvaluationTestCase(JsonStructure json, String pointer, JsonValue value) {
            this.json = json;
            this.pointer = pointer;
            this.value = value;
        }

        public String toString() {
            return this.pointer;
        }
    }

    static class RemovalTestCase {
        final JsonStructure json;
        final String pointer;
        final JsonValue result;

        RemovalTestCase(JsonStructure json, String pointer, JsonValue result) {
            this.json = json;
            this.pointer = pointer;
            this.result = result;
        }

        public String toString() {
            return this.pointer;
        }
    }

    static class AddOrReplaceTestCase {
        final JsonStructure json;
        final String pointer;
        final JsonValue value;
        final JsonValue result;

        AddOrReplaceTestCase(JsonStructure json, String pointer, JsonValue value, JsonValue result) {
            this.json = json;
            this.pointer = pointer;
            this.value = value;
            this.result = result;
        }

        public String toString() {
            return this.pointer;
        }
    }

    static enum JsonPointerTestCase {
        WHOLE("", true),
        FOO("/foo", true),
        FOO_0("/foo/0", true),
        SLASH("/", true),
        AB("/a~1b", true),
        CD("/c%d", true),
        EF("/e^f", true),
        GH("/g|h", true),
        IJ("/i\\\\j", true),
        KL("/k\\\"l", true),
        SPACE("/ ", true),
        MN("/m~0n", true),
        MULTIPLE_SLASH("//", true),
        ENDING_WITH_SLASH("/foo/", true),
        TILDE_FOLLOWED_BY_ILLEGAL_CHARACTER("/a~2b", true),
        TILDE_FOLLOWED_BY_SLASH("/a~/", true),
        ENDING_WITH_TILDE("/a~", true),
        MISSING_PREFIX_SLASH("foo", false);

        final String pointer;
        final boolean valid;

        private JsonPointerTestCase(String pointer, boolean valid) {
            this.pointer = pointer;
            this.valid = valid;
        }
    }
}

