/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.jsonp.testsuite.tests;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonPatch;
import jakarta.json.JsonStructure;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.leadpony.jsonp.testsuite.helper.LoggerFactory;
import org.leadpony.jsonp.testsuite.tests.TestCaseResource;

public class JsonPatchTest {
    private static final Logger LOG = LoggerFactory.getLogger(JsonPatchTest.class);

    public static Stream<PatchTestCase> applyShouldApplyOperationsAsExpected() {
        return Stream.of(TestCaseResource.RFC6902_EXAMPLES, TestCaseResource.JSON_PATCH).flatMap(TestCaseResource::getObjectStream).filter(object -> !object.getBoolean("skip", false)).map(PatchTestCase::new);
    }

    @ParameterizedTest
    @MethodSource
    public void applyShouldApplyOperationsAsExpected(PatchTestCase test) {
        JsonPatch patch = Json.createPatch((JsonArray)test.patch);
        Throwable thrown = Assertions.catchThrowable(() -> {
            JsonStructure actual = patch.apply(test.json);
            Assertions.assertThat((Object)actual).isEqualTo((Object)test.result);
        });
        if (test.result != null) {
            Assertions.assertThat((Throwable)thrown).isNull();
        } else {
            LOG.info(thrown.getMessage());
            ((AbstractThrowableAssert)Assertions.assertThat((Throwable)thrown).isNotNull()).isInstanceOf(JsonException.class);
        }
    }

    public static Stream<PatchTestCase> applyShouldThrowJsonExceptionIfMalformed() {
        return TestCaseResource.JSON_PATCH_MALFORMED.getObjectStream().map(PatchTestCase::new);
    }

    @ParameterizedTest
    @MethodSource
    public void applyShouldThrowJsonExceptionIfMalformed(PatchTestCase test) {
        try {
            JsonPatch patch = Json.createPatch((JsonArray)test.patch);
            Throwable thrown = Assertions.catchThrowable(() -> patch.apply(test.json));
            LOG.info(thrown.getMessage());
            ((AbstractThrowableAssert)Assertions.assertThat((Throwable)thrown).isNotNull()).isInstanceOf(JsonException.class);
        }
        catch (Exception e) {
            org.junit.jupiter.api.Assertions.fail((Throwable)e);
        }
    }

    static class PatchTestCase {
        final String title;
        final JsonStructure json;
        final JsonArray patch;
        final JsonStructure result;

        PatchTestCase(JsonObject object) {
            this.title = object.getString("title");
            this.json = (JsonStructure)object.get((Object)"json");
            this.patch = object.getJsonArray("patch");
            this.result = (JsonStructure)object.get((Object)"result");
        }

        public String toString() {
            return this.title;
        }
    }
}

