/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.jsonp.testsuite.tests;

import jakarta.json.Json;
import jakarta.json.JsonException;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParserFactory;
import java.io.Reader;
import java.io.StringReader;
import java.util.logging.Logger;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.leadpony.jsonp.testsuite.helper.LoggerFactory;
import org.leadpony.jsonp.testsuite.helper.Readers;

public class JsonParserIOExceptionTest {
    private static final Logger LOG = LoggerFactory.getLogger(JsonParserIOExceptionTest.class);
    private static JsonParserFactory parserFactory;

    @BeforeAll
    public static void setUpOnce() {
        parserFactory = Json.createParserFactory(null);
    }

    @Test
    public void nextShouldThrowJsonException() {
        Reader reader = Readers.throwingWhenReading(new StringReader("{}"));
        JsonParser parser = parserFactory.createParser(reader);
        Throwable thrown = Assertions.catchThrowable(() -> {
            parser.hasNext();
            parser.next();
        });
        Assertions.assertThat((Throwable)thrown).isInstanceOf(JsonException.class);
        LOG.info(thrown.getMessage());
    }

    @Test
    public void closeShouldThrowJsonException() {
        Reader reader = Readers.throwingWhenClosing(new StringReader("{}"));
        JsonParser parser = parserFactory.createParser(reader);
        Throwable thrown = Assertions.catchThrowable(() -> parser.close());
        Assertions.assertThat((Throwable)thrown).isInstanceOf(JsonException.class);
        LOG.info(thrown.getMessage());
    }
}

