/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.jsonp.testsuite.tests;

import jakarta.json.Json;
import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonGeneratorFactory;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.leadpony.jsonp.testsuite.annotation.Ambiguous;
import org.leadpony.jsonp.testsuite.tests.JsonResource;

@Ambiguous
public class JsonGeneratorPrettyPrintTest {
    private static JsonReaderFactory readerFactory;
    private static JsonGeneratorFactory generatorFactory;

    @BeforeAll
    public static void setUpOnce() {
        readerFactory = Json.createReaderFactory(null);
        HashMap<String, Boolean> config = new HashMap<String, Boolean>();
        config.put("jakarta.json.stream.JsonGenerator.prettyPrinting", Boolean.TRUE);
        generatorFactory = Json.createGeneratorFactory(config);
    }

    @ParameterizedTest
    @EnumSource(value=JsonResource.class)
    public void writeShouldGeneratePrettyPrintedJson(JsonResource test) {
        JsonValue value = JsonGeneratorPrettyPrintTest.readValue(test);
        StringWriter writer = new StringWriter();
        try (JsonGenerator g = generatorFactory.createGenerator((Writer)writer);){
            g.write(value);
        }
        String actual = writer.toString().trim();
        String expected = test.getJsonIndentedWithSpacesAsString(4);
        Assertions.assertThat((String)actual).isEqualTo(expected);
    }

    private static JsonValue readValue(JsonResource test) {
        try (JsonReader reader = readerFactory.createReader(test.openStream(), StandardCharsets.UTF_8);){
            JsonValue jsonValue = reader.readValue();
            return jsonValue;
        }
    }
}

