/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.jsonp.testsuite.tests;

import jakarta.json.Json;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonGeneratorFactory;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Logger;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.leadpony.jsonp.testsuite.helper.LoggerFactory;

public class JsonGeneratorNumberFormatExceptionTest {
    private static final Logger LOG = LoggerFactory.getLogger(JsonGeneratorNumberFormatExceptionTest.class);
    private static JsonGeneratorFactory factory;

    @BeforeAll
    public static void setUpOnce() {
        factory = Json.createGeneratorFactory(null);
    }

    @ParameterizedTest
    @EnumSource(value=IllegalDoubleTestCase.class)
    public void writeShouldThrowNumberFormatException(IllegalDoubleTestCase test) {
        JsonGenerator g = JsonGeneratorNumberFormatExceptionTest.generator();
        Throwable thrown = Assertions.catchThrowable(() -> g.write(test.value));
        LOG.info(thrown.getMessage());
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)thrown).isNotNull()).isInstanceOf(NumberFormatException.class);
    }

    @ParameterizedTest
    @EnumSource(value=IllegalNamedDoubleTestCase.class)
    public void writeShouldThrowNumberFormatException(IllegalNamedDoubleTestCase test) {
        JsonGenerator g = JsonGeneratorNumberFormatExceptionTest.generator();
        g.writeStartObject();
        Throwable thrown = Assertions.catchThrowable(() -> g.write(test.name, test.value));
        LOG.info(thrown.getMessage());
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)thrown).isNotNull()).isInstanceOf(NumberFormatException.class);
    }

    private static JsonGenerator generator() {
        StringWriter writer = new StringWriter();
        return factory.createGenerator((Writer)writer);
    }

    static enum IllegalNamedDoubleTestCase {
        NAN("abc", Double.NaN),
        NEGATIVE_INFINITY("abc", Double.NEGATIVE_INFINITY),
        POSITIVE_INFINITY("abc", Double.POSITIVE_INFINITY);

        final String name;
        final double value;

        private IllegalNamedDoubleTestCase(String name, double value) {
            this.name = name;
            this.value = value;
        }
    }

    static enum IllegalDoubleTestCase {
        NAN(Double.NaN),
        NEGATIVE_INFINITY(Double.NEGATIVE_INFINITY),
        POSITIVE_INFINITY(Double.POSITIVE_INFINITY);

        final double value;

        private IllegalDoubleTestCase(double value) {
            this.value = value;
        }
    }
}

