/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.jsonp.testsuite.tests;

import jakarta.json.Json;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerationException;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonGeneratorFactory;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.leadpony.jsonp.testsuite.helper.LoggerFactory;

public class JsonGenerationExceptionTest {
    private static final Logger LOG = LoggerFactory.getLogger(JsonGenerationExceptionTest.class);
    private static JsonGeneratorFactory factory;
    protected JsonGenerator g;

    @BeforeAll
    public static void setUpOnce() {
        factory = Json.createGeneratorFactory(null);
    }

    @BeforeEach
    public void setUp() {
        this.g = factory.createGenerator((Writer)new StringWriter());
    }

    @AfterEach
    public void tearDown() {
    }

    @Nested
    public class WhenInitial
    extends GeneratorSupplier
    implements WritingNameTest,
    WritingEndTest,
    ClosingTest {

        @Nested
        public class AfterWritingStartObject
        extends GeneratorSupplier
        implements WritingValueTest,
        ClosingTest {
            @BeforeEach
            public void setUp() {
                this.get().writeStartObject();
            }

            @Nested
            public class AfterWritingEnd
            extends GeneratorSupplier
            implements AllWritingTest {
                @BeforeEach
                public void setUp() {
                    this.get().writeEnd();
                }
            }

            @Nested
            public class AfterWritingKeyValue
            extends GeneratorSupplier
            implements WritingValueTest,
            ClosingTest {
                @BeforeEach
                public void setUp() {
                    this.get().write("key", "value");
                }

                @Nested
                public class AfterWritingEnd
                extends GeneratorSupplier
                implements AllWritingTest {
                    @BeforeEach
                    public void setUp() {
                        this.get().writeEnd();
                    }
                }
            }

            @Nested
            public class AfterWritingKey
            extends GeneratorSupplier
            implements WritingNameTest,
            WritingEndTest,
            ClosingTest {
                @BeforeEach
                public void setUp() {
                    this.get().writeKey("key");
                }

                @Test
                public void writeShouldStringValue() {
                    Assertions.assertThatCode(() -> this.get().write("value")).doesNotThrowAnyException();
                }

                @Nested
                public class AfterWritingValue
                extends GeneratorSupplier
                implements WritingValueTest,
                ClosingTest {
                    @BeforeEach
                    public void setUp() {
                        try {
                            this.get().write("value");
                        }
                        catch (JsonGenerationException e) {
                            Assumptions.assumeFalse((boolean)false);
                        }
                    }

                    @Nested
                    public class AfterWritingEnd
                    extends GeneratorSupplier
                    implements AllWritingTest {
                        @BeforeEach
                        public void setUp() {
                            try {
                                this.get().writeEnd();
                            }
                            catch (JsonGenerationException e) {
                                Assumptions.assumeFalse((boolean)false);
                            }
                        }
                    }
                }
            }
        }

        @Nested
        public class AfterWritingStartArray
        extends GeneratorSupplier
        implements WritingNameTest,
        ClosingTest {
            @BeforeEach
            public void setUp() {
                this.get().writeStartArray();
            }

            @Nested
            public class AfterWritingEnd
            extends GeneratorSupplier
            implements AllWritingTest {
                @BeforeEach
                public void setUp() {
                    this.get().writeEnd();
                }
            }

            @Nested
            public class AfterWritingFirstItem
            extends GeneratorSupplier
            implements WritingNameTest,
            ClosingTest {
                @BeforeEach
                public void setUp() {
                    this.get().write(123);
                }

                @Nested
                public class AfterWritingEnd
                extends GeneratorSupplier
                implements AllWritingTest {
                    @BeforeEach
                    public void setUp() {
                        this.get().writeEnd();
                    }
                }
            }
        }

        @Nested
        public class AfterWritingNull
        extends GeneratorSupplier
        implements AllWritingTest {
            @BeforeEach
            public void setUp() {
                this.get().writeNull();
            }
        }

        @Nested
        public class AfterWritingBoolean
        extends GeneratorSupplier
        implements AllWritingTest {
            @BeforeEach
            public void setUp() {
                this.get().write(true);
            }
        }

        @Nested
        public class AfterWritingDouble
        extends GeneratorSupplier
        implements AllWritingTest {
            @BeforeEach
            public void setUp() {
                this.get().write(3.14);
            }
        }

        @Nested
        public class AfterWritingLong
        extends GeneratorSupplier
        implements AllWritingTest {
            @BeforeEach
            public void setUp() {
                this.get().write(123L);
            }
        }

        @Nested
        public class AfterWritingInt
        extends GeneratorSupplier
        implements AllWritingTest {
            @BeforeEach
            public void setUp() {
                this.get().write(123);
            }
        }

        @Nested
        public class AfterWritingBigDecimal
        extends GeneratorSupplier
        implements AllWritingTest {
            @BeforeEach
            public void setUp() {
                this.get().write(new BigDecimal("3.14"));
            }
        }

        @Nested
        public class AfterWritingBigInteger
        extends GeneratorSupplier
        implements AllWritingTest {
            @BeforeEach
            public void setUp() {
                this.get().write(new BigInteger("42"));
            }
        }

        @Nested
        public class AfterWritingString
        extends GeneratorSupplier
        implements AllWritingTest {
            @BeforeEach
            public void setUp() {
                this.get().write("hello");
            }
        }

        @Nested
        public class AfterWritingJsonValue
        extends GeneratorSupplier
        implements AllWritingTest {
            @BeforeEach
            public void setUp() {
                this.get().write(JsonValue.TRUE);
            }
        }
    }

    static interface ClosingTest
    extends Supplier<JsonGenerator> {
        @Test
        default public void closeShouldThrowException() {
            Throwable thrown = Assertions.catchThrowable(() -> ((JsonGenerator)this.get()).close());
            Assertions.assertThat((Throwable)thrown).isInstanceOf(JsonGenerationException.class);
            LOG.info(thrown.getMessage());
        }
    }

    static interface AllWritingTest
    extends WritingValueTest,
    WritingNameTest,
    WritingEndTest {
    }

    static interface WritingEndTest
    extends Supplier<JsonGenerator> {
        @Test
        default public void writeEndShouldThrowException() {
            Throwable thrown = Assertions.catchThrowable(() -> ((JsonGenerator)this.get()).writeEnd());
            Assertions.assertThat((Throwable)thrown).isInstanceOf(JsonGenerationException.class);
            LOG.info(thrown.getMessage());
        }
    }

    static interface WritingNameTest
    extends Supplier<JsonGenerator> {
        @Test
        default public void writeStartArrayWithNameShouldThrowException() {
            Throwable thrown = Assertions.catchThrowable(() -> ((JsonGenerator)this.get()).writeStartArray("key"));
            Assertions.assertThat((Throwable)thrown).isInstanceOf(JsonGenerationException.class);
            LOG.info(thrown.getMessage());
        }

        @Test
        default public void writeStartObjectWithNameShouldThrowException() {
            Throwable thrown = Assertions.catchThrowable(() -> ((JsonGenerator)this.get()).writeStartObject("key"));
            Assertions.assertThat((Throwable)thrown).isInstanceOf(JsonGenerationException.class);
            LOG.info(thrown.getMessage());
        }

        @Test
        default public void writeKeyShouldThrowException() {
            Throwable thrown = Assertions.catchThrowable(() -> ((JsonGenerator)this.get()).writeKey("key"));
            Assertions.assertThat((Throwable)thrown).isInstanceOf(JsonGenerationException.class);
            LOG.info(thrown.getMessage());
        }
    }

    static interface WritingValueTest
    extends Supplier<JsonGenerator> {
        @Test
        default public void writeStartArrayShouldThrowException() {
            Throwable thrown = Assertions.catchThrowable(() -> ((JsonGenerator)this.get()).writeStartArray());
            Assertions.assertThat((Throwable)thrown).isInstanceOf(JsonGenerationException.class);
            LOG.info(thrown.getMessage());
        }

        @Test
        default public void writeStartObjectShouldThrowException() {
            Throwable thrown = Assertions.catchThrowable(() -> ((JsonGenerator)this.get()).writeStartObject());
            Assertions.assertThat((Throwable)thrown).isInstanceOf(JsonGenerationException.class);
            LOG.info(thrown.getMessage());
        }

        @Test
        default public void writeJsonValueShouldThrowException() {
            Throwable thrown = Assertions.catchThrowable(() -> ((JsonGenerator)this.get()).write(JsonValue.TRUE));
            Assertions.assertThat((Throwable)thrown).isInstanceOf(JsonGenerationException.class);
            LOG.info(thrown.getMessage());
        }

        @Test
        default public void writeStringShouldThrowException() {
            Throwable thrown = Assertions.catchThrowable(() -> ((JsonGenerator)this.get()).write("hello"));
            Assertions.assertThat((Throwable)thrown).isInstanceOf(JsonGenerationException.class);
            LOG.info(thrown.getMessage());
        }

        @Test
        default public void writeBigIntegerShouldThrowException() {
            Throwable thrown = Assertions.catchThrowable(() -> ((JsonGenerator)this.get()).write(new BigInteger("42")));
            Assertions.assertThat((Throwable)thrown).isInstanceOf(JsonGenerationException.class);
            LOG.info(thrown.getMessage());
        }

        @Test
        default public void writeBigDecimalShouldThrowException() {
            Throwable thrown = Assertions.catchThrowable(() -> ((JsonGenerator)this.get()).write(new BigDecimal("42")));
            Assertions.assertThat((Throwable)thrown).isInstanceOf(JsonGenerationException.class);
            LOG.info(thrown.getMessage());
        }

        @Test
        default public void writeIntShouldThrowException() {
            Throwable thrown = Assertions.catchThrowable(() -> ((JsonGenerator)this.get()).write(42));
            Assertions.assertThat((Throwable)thrown).isInstanceOf(JsonGenerationException.class);
            LOG.info(thrown.getMessage());
        }

        @Test
        default public void writeLongShouldThrowException() {
            Throwable thrown = Assertions.catchThrowable(() -> ((JsonGenerator)this.get()).write(42L));
            Assertions.assertThat((Throwable)thrown).isInstanceOf(JsonGenerationException.class);
            LOG.info(thrown.getMessage());
        }

        @Test
        default public void writeBooleanShouldThrowException() {
            Throwable thrown = Assertions.catchThrowable(() -> ((JsonGenerator)this.get()).write(true));
            Assertions.assertThat((Throwable)thrown).isInstanceOf(JsonGenerationException.class);
            LOG.info(thrown.getMessage());
        }

        @Test
        default public void writeNullShouldThrowException() {
            Throwable thrown = Assertions.catchThrowable(() -> ((JsonGenerator)this.get()).writeNull());
            Assertions.assertThat((Throwable)thrown).isInstanceOf(JsonGenerationException.class);
            LOG.info(thrown.getMessage());
        }
    }

    class GeneratorSupplier
    implements Supplier<JsonGenerator> {
        GeneratorSupplier() {
        }

        @Override
        public JsonGenerator get() {
            return JsonGenerationExceptionTest.this.g;
        }
    }
}

