/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.jsonp.testsuite.tests;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.leadpony.jsonp.testsuite.annotation.Ambiguous;

public class JsonBuilderFactoryTest {
    @ParameterizedTest
    @EnumSource(value=CollectionTestCase.class)
    public void createArrayBuilderShouldCreateBuilderFilledWithCollection(CollectionTestCase test) {
        JsonBuilderFactory factory = JsonBuilderFactoryTest.createFactory();
        try {
            JsonArrayBuilder builder = factory.createArrayBuilder(test.collection);
            JsonArray actual = builder.build();
            Assertions.assertThat((List)actual).isEqualTo((Object)test.expected);
        }
        catch (Exception e) {
            org.junit.jupiter.api.Assertions.fail((Throwable)e);
        }
    }

    @Ambiguous
    @ParameterizedTest
    @EnumSource(value=AmbiguousCollectionTestCase.class)
    public void createArrayBuilderShouldCreateBuilderFilledWithCollection(AmbiguousCollectionTestCase test) {
        JsonBuilderFactory factory = JsonBuilderFactoryTest.createFactory();
        try {
            JsonArrayBuilder builder = factory.createArrayBuilder(test.collection);
            JsonArray actual = builder.build();
            Assertions.assertThat((List)actual).isEqualTo((Object)test.expected);
        }
        catch (Exception e) {
            org.junit.jupiter.api.Assertions.fail((Throwable)e);
        }
    }

    @ParameterizedTest
    @EnumSource(value=MapTestCase.class)
    public void createObjectBuilderShouldCreateBuilderFilledWithMap(MapTestCase test) {
        JsonBuilderFactory factory = JsonBuilderFactoryTest.createFactory();
        try {
            JsonObjectBuilder builder = factory.createObjectBuilder(test.map);
            JsonObject actual = builder.build();
            Assertions.assertThat((Map)actual).isEqualTo((Object)test.expected);
        }
        catch (Exception e) {
            org.junit.jupiter.api.Assertions.fail((Throwable)e);
        }
    }

    @Ambiguous
    @ParameterizedTest
    @EnumSource(value=AmbiguousMapTestCase.class)
    public void createObjectBuilderShouldCreateBuilderFilledWithMap(AmbiguousMapTestCase test) {
        JsonBuilderFactory factory = JsonBuilderFactoryTest.createFactory();
        try {
            JsonObjectBuilder builder = factory.createObjectBuilder(test.map);
            JsonObject actual = builder.build();
            Assertions.assertThat((Map)actual).isEqualTo((Object)test.expected);
        }
        catch (Exception e) {
            org.junit.jupiter.api.Assertions.fail((Throwable)e);
        }
    }

    @Test
    public void getConfigInUseShouldReturnEmptyMap() {
        HashMap config = new HashMap();
        JsonBuilderFactory factory = JsonBuilderFactoryTest.createFactory(config);
        Map actual = factory.getConfigInUse();
        Assertions.assertThat((Map)actual).isEmpty();
    }

    @Test
    public void getConfigInUseShouldNotContainUnknownProperty() {
        HashMap<String, Boolean> config = new HashMap<String, Boolean>();
        config.put("unknown", Boolean.TRUE);
        JsonBuilderFactory factory = JsonBuilderFactoryTest.createFactory(config);
        Map actual = factory.getConfigInUse();
        Assertions.assertThat((Map)actual).doesNotContainKey((Object)"unknown");
    }

    private static JsonBuilderFactory createFactory() {
        return Json.createBuilderFactory(Collections.emptyMap());
    }

    private static JsonBuilderFactory createFactory(Map<String, ?> config) {
        return Json.createBuilderFactory(config);
    }

    private static Collection<?> collection(Object ... objects) {
        return Arrays.asList(objects);
    }

    private static Map<String, Object> map(Consumer<Map<String, Object>> consumer) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        consumer.accept(map);
        return map;
    }

    private static JsonArray array(Consumer<JsonArrayBuilder> consumer) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        consumer.accept(builder);
        return builder.build();
    }

    private static JsonObject object(Consumer<JsonObjectBuilder> consumer) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        consumer.accept(builder);
        return builder.build();
    }

    static /* synthetic */ Collection access$000(Object[] x0) {
        return JsonBuilderFactoryTest.collection(x0);
    }

    static /* synthetic */ Map access$300(Consumer x0) {
        return JsonBuilderFactoryTest.map(x0);
    }

    static enum AmbiguousMapTestCase {
        OBJECT_BUILDER(JsonBuilderFactoryTest.access$300(m -> {
            m.put("a", "hello");
            m.put("b", JsonBuilderFactoryTest.createFactory().createObjectBuilder().add("x", 365));
        }), JsonBuilderFactoryTest.access$400(b -> b.add("a", "hello").add("b", (JsonValue)JsonBuilderFactoryTest.object(b2 -> b2.add("x", 365)))));

        final Map<String, Object> map;
        final JsonObject expected;

        private AmbiguousMapTestCase(Map<String, Object> map, JsonObject expected) {
            this.map = map;
            this.expected = expected;
        }
    }

    static enum MapTestCase {
        EMPTY(Collections.emptyMap(), JsonValue.EMPTY_JSON_OBJECT),
        MAP(JsonBuilderFactoryTest.access$300(m -> {
            m.put("a", "hello");
            m.put("b", 365);
            m.put("c", 3.14);
            m.put("d", true);
            m.put("e", null);
        }), JsonBuilderFactoryTest.access$400(b -> b.add("a", "hello").add("b", 365).add("c", 3.14).add("d", true).addNull("e"))),
        MAX_INTEGER(JsonBuilderFactoryTest.access$300(m -> m.put("a", Integer.MAX_VALUE)), JsonBuilderFactoryTest.access$400(b -> b.add("a", Integer.MAX_VALUE))),
        MIN_INTEGER(JsonBuilderFactoryTest.access$300(m -> m.put("a", Integer.MIN_VALUE)), JsonBuilderFactoryTest.access$400(b -> b.add("a", Integer.MIN_VALUE))),
        MAX_LONG(JsonBuilderFactoryTest.access$300(m -> m.put("a", Long.MAX_VALUE)), JsonBuilderFactoryTest.access$400(b -> b.add("a", Long.MAX_VALUE))),
        MIN_LONG(JsonBuilderFactoryTest.access$300(m -> m.put("a", Long.MIN_VALUE)), JsonBuilderFactoryTest.access$400(b -> b.add("a", Long.MIN_VALUE))),
        MAX_DOUBLE(JsonBuilderFactoryTest.access$300(m -> m.put("a", Double.MAX_VALUE)), JsonBuilderFactoryTest.access$400(b -> b.add("a", Double.MAX_VALUE))),
        MIN_DOUBLE(JsonBuilderFactoryTest.access$300(m -> m.put("a", Double.MIN_VALUE)), JsonBuilderFactoryTest.access$400(b -> b.add("a", Double.MIN_VALUE))),
        JSON_VALUE_TRUE(JsonBuilderFactoryTest.access$300(m -> m.put("a", JsonValue.TRUE)), JsonBuilderFactoryTest.access$400(b -> b.add("a", JsonValue.TRUE))),
        JSON_VALUE_FALSE(JsonBuilderFactoryTest.access$300(m -> m.put("a", JsonValue.FALSE)), JsonBuilderFactoryTest.access$400(b -> b.add("a", JsonValue.FALSE))),
        JSON_VALUE_NULL(JsonBuilderFactoryTest.access$300(m -> m.put("a", JsonValue.NULL)), JsonBuilderFactoryTest.access$400(b -> b.add("a", JsonValue.NULL)));

        final Map<String, Object> map;
        final JsonObject expected;

        private MapTestCase(Map<String, Object> map, JsonObject expected) {
            this.map = map;
            this.expected = expected;
        }
    }

    static enum AmbiguousCollectionTestCase {
        ARRAY_BUILDER(JsonBuilderFactoryTest.access$000(new Object[]{"hello", JsonBuilderFactoryTest.access$200().createArrayBuilder().add(365)}), JsonBuilderFactoryTest.access$100(b -> b.add("hello").add((JsonValue)JsonBuilderFactoryTest.array(b2 -> b2.add(365)))));

        final Collection<?> collection;
        final JsonArray expected;

        private AmbiguousCollectionTestCase(Collection<?> collection, JsonArray expected) {
            this.collection = collection;
            this.expected = expected;
        }
    }

    static enum CollectionTestCase {
        EMPTY(Collections.emptyList(), JsonValue.EMPTY_JSON_ARRAY),
        LIST(JsonBuilderFactoryTest.access$000(new Object[]{"hello", 365, 3.14, true, null}), JsonBuilderFactoryTest.access$100(b -> b.add("hello").add(365).add(3.14).add(true).addNull())),
        MAX_INTEGER(JsonBuilderFactoryTest.access$000(new Object[]{Integer.MAX_VALUE}), JsonBuilderFactoryTest.access$100(b -> b.add(Integer.MAX_VALUE))),
        MIN_INTEGER(JsonBuilderFactoryTest.access$000(new Object[]{Integer.MIN_VALUE}), JsonBuilderFactoryTest.access$100(b -> b.add(Integer.MIN_VALUE))),
        MAX_LONG(JsonBuilderFactoryTest.access$000(new Object[]{Long.MAX_VALUE}), JsonBuilderFactoryTest.access$100(b -> b.add(Long.MAX_VALUE))),
        MIN_LONG(JsonBuilderFactoryTest.access$000(new Object[]{Long.MIN_VALUE}), JsonBuilderFactoryTest.access$100(b -> b.add(Long.MIN_VALUE))),
        MAX_DOUBLE(JsonBuilderFactoryTest.access$000(new Object[]{Double.MAX_VALUE}), JsonBuilderFactoryTest.access$100(b -> b.add(Double.MAX_VALUE))),
        MIN_DOUBLE(JsonBuilderFactoryTest.access$000(new Object[]{Double.MIN_VALUE}), JsonBuilderFactoryTest.access$100(b -> b.add(Double.MIN_VALUE))),
        JSON_VALUE_TRUE(JsonBuilderFactoryTest.access$000(new Object[]{JsonValue.TRUE}), JsonBuilderFactoryTest.access$100(b -> b.add(JsonValue.TRUE))),
        JSON_VALUE_FALSE(JsonBuilderFactoryTest.access$000(new Object[]{JsonValue.FALSE}), JsonBuilderFactoryTest.access$100(b -> b.add(JsonValue.FALSE))),
        JSON_VALUE_NULL(JsonBuilderFactoryTest.access$000(new Object[]{JsonValue.NULL}), JsonBuilderFactoryTest.access$100(b -> b.add(JsonValue.NULL)));

        final Collection<?> collection;
        final JsonArray expected;

        private CollectionTestCase(Collection<?> collection, JsonArray expected) {
            this.collection = collection;
            this.expected = expected;
        }
    }
}

