/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.jsonp.testsuite.tests;

import jakarta.json.Json;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParserFactory;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.leadpony.jsonp.testsuite.tests.JsonTestCase;

public class CharsetDetectionTest {
    static final Charset UTF_32BE = Charset.forName("UTF-32BE");
    static final Charset UTF_32LE = Charset.forName("UTF-32LE");
    private static final byte[] UTF_8_BOM = new byte[]{-17, -69, -65};
    private static final byte[] UTF_16BE_BOM = new byte[]{-2, -1};
    private static final byte[] UTF_16LE_BOM = new byte[]{-1, -2};
    private static final byte[] UTF_32BE_BOM = new byte[]{0, 0, -2, -1};
    private static final byte[] UTF_32LE_BOM = new byte[]{-1, -2, 0, 0};
    private static JsonParserFactory parserFactory;

    @BeforeAll
    public static void setUpOnce() {
        parserFactory = Json.createParserFactory(null);
    }

    @ParameterizedTest
    @EnumSource(value=JsonTestCase.class)
    public void utf8(JsonTestCase test) {
        this.testParser(test, StandardCharsets.UTF_8);
    }

    @ParameterizedTest
    @EnumSource(value=JsonTestCase.class)
    public void utf16be(JsonTestCase test) {
        this.testParser(test, StandardCharsets.UTF_16BE);
    }

    @ParameterizedTest
    @EnumSource(value=JsonTestCase.class)
    public void utf16le(JsonTestCase test) {
        this.testParser(test, StandardCharsets.UTF_16LE);
    }

    @ParameterizedTest
    @EnumSource(value=JsonTestCase.class)
    public void utf32be(JsonTestCase test) {
        this.testParser(test, UTF_32BE);
    }

    @ParameterizedTest
    @EnumSource(value=JsonTestCase.class)
    public void utf32le(JsonTestCase test) {
        this.testParser(test, UTF_32LE);
    }

    @ParameterizedTest
    @EnumSource(value=JsonTestCase.class)
    public void utf8WithBom(JsonTestCase test) {
        this.testParser(test, StandardCharsets.UTF_8, UTF_8_BOM);
    }

    @ParameterizedTest
    @EnumSource(value=JsonTestCase.class)
    public void utf16beWithBom(JsonTestCase test) {
        this.testParser(test, StandardCharsets.UTF_16BE, UTF_16BE_BOM);
    }

    @ParameterizedTest
    @EnumSource(value=JsonTestCase.class)
    public void utf16leWithBom(JsonTestCase test) {
        this.testParser(test, StandardCharsets.UTF_16LE, UTF_16LE_BOM);
    }

    @ParameterizedTest
    @EnumSource(value=JsonTestCase.class)
    public void utf32beWithBom(JsonTestCase test) {
        this.testParser(test, UTF_32BE, UTF_32BE_BOM);
    }

    @ParameterizedTest
    @EnumSource(value=JsonTestCase.class)
    public void utf32leWithBom(JsonTestCase test) {
        this.testParser(test, UTF_32LE, UTF_32LE_BOM);
    }

    private void testParser(JsonTestCase test, Charset charset) {
        InputStream in = this.createEncodedStream(test.getJson(), charset);
        Assertions.assertThatCode(() -> {
            JsonParser parser = parserFactory.createParser(in);
            while (parser.hasNext()) {
                parser.next();
            }
            parser.close();
        }).doesNotThrowAnyException();
    }

    private void testParser(JsonTestCase test, Charset charset, byte[] bom) {
        InputStream in = this.createEncodedStream(test.getJson(), charset, bom);
        Assertions.assertThatCode(() -> {
            JsonParser parser = parserFactory.createParser(in);
            while (parser.hasNext()) {
                parser.next();
            }
            parser.close();
        }).doesNotThrowAnyException();
    }

    private InputStream createEncodedStream(String json, Charset charset) {
        ByteBuffer buffer = charset.encode(json);
        return new ByteArrayInputStream(buffer.array(), 0, buffer.remaining());
    }

    private InputStream createEncodedStream(String json, Charset charset, byte[] bom) {
        ByteBuffer buffer = charset.encode(json);
        byte[] bytes = new byte[bom.length + buffer.remaining()];
        System.arraycopy(bom, 0, bytes, 0, bom.length);
        System.arraycopy(buffer.array(), 0, bytes, bom.length, buffer.remaining());
        return new ByteArrayInputStream(bytes);
    }
}

