/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.vocabulary;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.namespace.QName;
import org.ldp4j.application.vocabulary.AdapterMethodValidator;
import org.ldp4j.application.vocabulary.CannotAdaptClassesException;
import org.ldp4j.application.vocabulary.Term;
import org.ldp4j.application.vocabulary.Vocabulary;

final class TypeAdapter<S, T> {
    static final String ADAPTER_NAME_CONVENTION = "adaptTo";
    static final CopyOnWriteArrayList<Class<?>> ADAPTER_CLASSES = Lists.newCopyOnWriteArrayList();
    private final Class<? extends T> resultClass;
    private final Method adapterMethod;

    private TypeAdapter(Method adapterMethod, Class<? extends T> resultClass) {
        this.adapterMethod = adapterMethod;
        this.resultClass = resultClass;
    }

    private String getAdapterFailureMessage(String messageTemplate, Object ... args) {
        return String.format("Chosen adapter method '%s' ", this.adapterMethod).concat(String.format(messageTemplate, args));
    }

    T adapt(S value) {
        try {
            T result = this.resultClass.cast(this.adapterMethod.invoke(null, value));
            if (result == null) {
                throw new IllegalStateException(this.getAdapterFailureMessage("could not adapt value '%s", value));
            }
            return result;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(this.getAdapterFailureMessage("should accept '%s'", value.getClass().getCanonicalName()), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(this.getAdapterFailureMessage("should be accesible", new Object[0]), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(this.getAdapterFailureMessage("failed while adapting value '%s'", value), e);
        }
    }

    private static Collection<Class<?>> findTypeAdapters() {
        return ImmutableList.copyOf(ADAPTER_CLASSES);
    }

    private static <S, T> TypeAdapter<S, T> doCreateAdapter(Class<? extends T> targetType, AdapterMethodValidator validator) {
        for (Class<?> termAdapter : TypeAdapter.findTypeAdapters()) {
            for (Method candidate : termAdapter.getMethods()) {
                if (!validator.isValid(candidate)) continue;
                return new TypeAdapter<S, T>(candidate, targetType);
            }
        }
        throw new CannotAdaptClassesException("Could not find adapter of adapting class '" + validator.getTargetClass().getCanonicalName() + "' to '" + targetType.getCanonicalName() + "'");
    }

    static void registerAdapterClass(Class<?> clazz) {
        Objects.requireNonNull(clazz, "Adapter class cannot be null");
        ADAPTER_CLASSES.addIfAbsent(clazz);
    }

    static <S, T> TypeAdapter<S, T> createAdapter(Class<? extends S> sourceType, Class<? extends T> targetType) {
        return TypeAdapter.doCreateAdapter(targetType, AdapterMethodValidator.newInstance(targetType, sourceType));
    }

    static <S, T> T adapt(S object, Class<? extends T> resultClass) {
        return TypeAdapter.doCreateAdapter(resultClass, AdapterMethodValidator.newInstance(resultClass, object)).adapt(object);
    }

    static {
        TypeAdapter.registerAdapterClass(URIAdapter.class);
        TypeAdapter.registerAdapterClass(QNameAdapter.class);
    }

    static final class URIAdapter {
        private URIAdapter() {
        }

        public static URI adaptTo(Term term) {
            return URI.create(term.getDeclaringVocabulary().getNamespace() + term.entityName());
        }
    }

    static final class QNameAdapter {
        private QNameAdapter() {
        }

        public static QName adaptTo(Term term) {
            Vocabulary vocabulary = term.getDeclaringVocabulary();
            return new QName(vocabulary.getNamespace(), term.entityName(), vocabulary.getPreferredPrefix());
        }
    }
}

