/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.data;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.net.URI;
import org.ldp4j.application.data.Name;

public final class ManagedIndividualId
implements Serializable {
    private static final long serialVersionUID = 3320976326537867325L;
    private final String managerId;
    private final Name<?> name;
    private final URI indirectId;

    private ManagedIndividualId(Name<?> name, String managerId, URI indirectId) {
        this.name = name;
        this.managerId = managerId;
        this.indirectId = indirectId;
    }

    public Name<?> name() {
        return this.name;
    }

    public String managerId() {
        return this.managerId;
    }

    public URI indirectId() {
        return this.indirectId;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.managerId, this.indirectId});
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj != null && obj.getClass() == this.getClass()) {
            ManagedIndividualId that = (ManagedIndividualId)obj;
            result = Objects.equal(this.name, that.name) && Objects.equal((Object)this.managerId, (Object)that.managerId) && Objects.equal((Object)this.indirectId, (Object)that.indirectId);
        }
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("name", this.name).add("managerId", (Object)this.managerId).add("indirectId", (Object)this.indirectId).toString();
    }

    public static ManagedIndividualId createId(Name<?> name, String managerId) {
        Preconditions.checkNotNull(name, (Object)"Resource name cannot be null");
        Preconditions.checkNotNull((Object)managerId, (Object)"Manager identifier cannot be null");
        return new ManagedIndividualId(name, managerId, null);
    }

    public static ManagedIndividualId createId(URI indirectId, ManagedIndividualId parent) {
        Preconditions.checkNotNull((Object)indirectId, (Object)"Indirect identifier cannot be null");
        Preconditions.checkNotNull((Object)parent, (Object)"Parent identifier cannot be null");
        return new ManagedIndividualId(parent.name, parent.managerId, indirectId);
    }
}

