/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.data;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.ldp4j.application.data.DataSet;
import org.ldp4j.application.data.FormatUtils;
import org.ldp4j.application.data.Individual;
import org.ldp4j.application.data.IndividualFactory;
import org.ldp4j.application.data.Literal;
import org.ldp4j.application.data.Name;
import org.ldp4j.application.data.Property;
import org.ldp4j.application.data.Value;
import org.ldp4j.application.data.ValueVisitor;

final class MutableDataSet
implements DataSet {
    private final Name<?> name;
    private final Map<Serializable, Individual<?, ?>> individuals;
    private final IndividualFactory factory;

    MutableDataSet(Name<?> name) {
        this.name = name;
        this.individuals = Maps.newLinkedHashMap();
        this.factory = new IndividualFactory(this);
    }

    @Override
    public Name<?> name() {
        return this.name;
    }

    @Override
    public int numberOfIndividuals() {
        return this.individuals.size();
    }

    @Override
    public boolean hasIndividuals() {
        return !this.individuals.isEmpty();
    }

    public Collection<Individual<?, ?>> individuals() {
        return new ArrayList(this.individuals.values());
    }

    @Override
    public Set<Serializable> individualIds() {
        return new LinkedHashSet<Serializable>(this.individuals.keySet());
    }

    @Override
    public boolean hasIndividual(Object id) {
        return this.individuals.containsKey(id);
    }

    @Override
    public <T extends Serializable, S extends Individual<T, S>> S individualOfId(T id) {
        return (S)this.individuals.get(id);
    }

    @Override
    public <T extends Serializable, S extends Individual<T, S>> S individual(T id, Class<? extends S> clazz) {
        Object result = this.individualOfId(id);
        if (result == null) {
            result = this.factory.newIndividual(clazz, id);
            this.individuals.put(id, (Individual<?, ?>)result);
        } else if (!clazz.isInstance(result)) {
            throw new IllegalStateException("Existing individual '" + id + "' is not compatible with '" + clazz.getCanonicalName() + "' (" + result.getClass().getCanonicalName() + ")");
        }
        return (S)((Individual)clazz.cast(result));
    }

    @Override
    public Iterator<Individual<?, ?>> iterator() {
        return this.individuals().iterator();
    }

    @Override
    public boolean isEmpty() {
        for (Individual<?, ?> individual : this) {
            for (Property property : individual) {
                if (!property.hasValues()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void remove(Individual<?, ?> src) {
        if (this != src.dataSet()) {
            return;
        }
        for (Individual<?, ?> individual : this) {
            for (Property property : individual) {
                for (Value value : property) {
                    value.accept(new IndividualRemover(property, src, individual));
                }
            }
        }
        this.individuals.remove(src.id());
    }

    public String toString() {
        return FormatUtils.formatDataSet(this);
    }

    private final class IndividualRemover
    implements ValueVisitor {
        private final Property property;
        private final Individual<?, ?> src;
        private final Individual<?, ?> individual;

        private IndividualRemover(Property property, Individual<?, ?> src, Individual<?, ?> individual) {
            this.property = property;
            this.src = src;
            this.individual = individual;
        }

        @Override
        public void visitLiteral(Literal<?> value) {
        }

        @Override
        public void visitIndividual(Individual<?, ?> value) {
            if (value == this.src) {
                this.individual.removeValue(this.property.predicate(), value);
            }
        }
    }
}

