/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application;

import com.google.common.base.Preconditions;
import java.lang.ref.ReferenceQueue;
import org.ldp4j.application.ContextWriteSession;
import org.ldp4j.application.ContextWriteSessionReference;
import org.ldp4j.application.ContextWriteSessionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WriteSessionCleaner {
    private static final Logger LOGGER = LoggerFactory.getLogger(WriteSessionCleaner.class);
    private static WriteSessionCleaner instance;
    private final ReferenceQueue<ContextWriteSession> referenceQueue;
    private volatile boolean terminate;
    private Thread thread;

    private WriteSessionCleaner(ReferenceQueue<ContextWriteSession> referenceQueue) {
        this.referenceQueue = referenceQueue;
    }

    private void bootstrapThread() {
        this.thread = new Thread((Runnable)new Worker(), "ApplicationContext-WriteSessionCleaner");
        this.thread.setPriority(10);
        this.thread.setDaemon(true);
        this.thread.setUncaughtExceptionHandler(new Restarter());
        this.thread.start();
    }

    private synchronized void restart() {
        if (this.isRunning()) {
            this.bootstrapThread();
        }
    }

    synchronized void start() {
        Preconditions.checkState((!this.isRunning() ? 1 : 0) != 0, (Object)"Write Session Cleaner is already running");
        this.bootstrapThread();
    }

    synchronized void shutdown() {
        if (this.isRunning()) {
            this.terminate = true;
            this.thread.interrupt();
            this.thread = null;
        }
    }

    private synchronized boolean isRunning() {
        return this.thread != null;
    }

    static synchronized void launch(ReferenceQueue<ContextWriteSession> referenceQueue) {
        if (!WriteSessionCleaner.isActive()) {
            instance = new WriteSessionCleaner(referenceQueue);
            instance.start();
        }
    }

    static synchronized void terminate() {
        if (WriteSessionCleaner.isActive()) {
            instance.shutdown();
        }
    }

    static synchronized boolean isActive() {
        if (instance == null) {
            return false;
        }
        return instance.isRunning();
    }

    private final class Worker
    implements Runnable {
        private Worker() {
        }

        @Override
        public void run() {
            while (!WriteSessionCleaner.this.terminate) {
                try {
                    ContextWriteSessionReference ref = (ContextWriteSessionReference)WriteSessionCleaner.this.referenceQueue.remove();
                    ContextWriteSessionState state = ref.state();
                    LOGGER.trace("Session {} is now weakly reachable...", (Object)state);
                    state.dispose();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private final class Restarter
    implements Thread.UncaughtExceptionHandler {
        private Restarter() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            LOGGER.error("Cleaner thread unexpectedly died. Full stacktrace follows", e);
            WriteSessionCleaner.this.restart();
        }
    }
}

