/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import mockit.Deencapsulation;
import mockit.Mock;
import mockit.MockUp;
import mockit.Mocked;
import mockit.integration.junit4.JMockit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.ldp4j.application.ContextWriteSession;
import org.ldp4j.application.ContextWriteSessionReference;
import org.ldp4j.application.ContextWriteSessionState;
import org.ldp4j.application.WriteSessionCleaner;

@RunWith(value=JMockit.class)
public class WriteSessionCleanerTest {
    @Rule
    public Timeout timeout = Timeout.builder().withTimeout(5L, TimeUnit.SECONDS).withLookingForStuckThread(true).build();

    @Before
    public void setUp() throws InterruptedException {
        WriteSessionCleaner instance = (WriteSessionCleaner)Deencapsulation.getField(WriteSessionCleaner.class, WriteSessionCleaner.class);
        if (instance != null) {
            instance.shutdown();
            Thread lastThread = (Thread)Deencapsulation.getField((Object)instance, Thread.class);
            if (lastThread != null) {
                lastThread.join();
            }
        }
        Deencapsulation.setField(WriteSessionCleaner.class, (String)"instance", null);
    }

    @Test
    public void assertThatIsActiveWhenNotLaunchedShouldBeFalse() {
        MatcherAssert.assertThat((Object)WriteSessionCleaner.isActive(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void assertThatTerminateWhenInactiveDoesNotBreak() {
        WriteSessionCleaner.terminate();
    }

    @Test
    public void assertThatLaunchOnlyAllowsOneInstance() {
        ReferenceQueue referenceQueue = new ReferenceQueue();
        int t1 = Thread.activeCount();
        WriteSessionCleaner.launch(referenceQueue);
        this.awaitStartUp();
        int t2 = Thread.activeCount();
        WriteSessionCleaner.launch(referenceQueue);
        int t3 = Thread.activeCount();
        MatcherAssert.assertThat((Object)t2, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(t1)));
        MatcherAssert.assertThat((Object)t3, (Matcher)Matchers.equalTo((Object)t2));
    }

    @Test
    public void testLifecycle(@Mocked ContextWriteSession referent) throws Exception {
        ReferenceQueue referenceQueue = new ReferenceQueue();
        final CountDownLatch disposed = new CountDownLatch(1);
        ContextWriteSessionState state = (ContextWriteSessionState)new MockUp<ContextWriteSessionState>(){

            @Mock
            void dispose() {
                disposed.countDown();
            }
        }.getMockInstance();
        ContextWriteSessionReference reference = new ContextWriteSessionReference(referent, state, referenceQueue);
        WriteSessionCleaner.launch(referenceQueue);
        Deencapsulation.invoke(referenceQueue, (String)"enqueue", (Object[])new Object[]{reference});
        disposed.await();
        WriteSessionCleaner.terminate();
        this.awaitTermination();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCannotStartTwice() throws Exception {
        ReferenceQueue referenceQueue = new ReferenceQueue();
        WriteSessionCleaner sut = (WriteSessionCleaner)Deencapsulation.newInstance(WriteSessionCleaner.class, (Object[])new Object[]{referenceQueue});
        sut.start();
        Thread firstThread = (Thread)Deencapsulation.getField((Object)sut, Thread.class);
        try {
            sut.start();
        }
        catch (IllegalStateException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"Write Session Cleaner is already running"));
        }
        finally {
            sut.shutdown();
            firstThread.join();
        }
    }

    @Test
    public void testTerminatesWhenRequested() throws Exception {
        ReferenceQueue referenceQueue = new ReferenceQueue();
        WriteSessionCleaner.launch(referenceQueue);
        this.awaitStartUp();
        WriteSessionCleaner.terminate();
        this.awaitTermination();
    }

    @Test
    public void testRestartsOnFailure() throws Exception {
        final CountDownLatch started = new CountDownLatch(1);
        final CountDownLatch failed = new CountDownLatch(1);
        ReferenceQueue<ContextWriteSession> referenceQueue = new ReferenceQueue<ContextWriteSession>(){

            @Override
            public Reference<? extends ContextWriteSession> remove() throws InterruptedException {
                started.await();
                failed.countDown();
                throw new Error("Failure");
            }
        };
        WriteSessionCleaner sut = (WriteSessionCleaner)Deencapsulation.newInstance(WriteSessionCleaner.class, (Object[])new Object[]{referenceQueue});
        sut.start();
        Thread firstThread = (Thread)Deencapsulation.getField((Object)sut, Thread.class);
        started.countDown();
        failed.await();
        firstThread.join();
        sut.shutdown();
        Thread lastThread = (Thread)Deencapsulation.getField((Object)sut, Thread.class);
        if (lastThread != null) {
            lastThread.join();
        }
    }

    @Test
    public void testRestartsOnFailureUnlessTerminationIsNotified() throws Exception {
        final CountDownLatch fail = new CountDownLatch(1);
        ReferenceQueue<ContextWriteSession> referenceQueue = new ReferenceQueue<ContextWriteSession>(){

            @Override
            public Reference<? extends ContextWriteSession> remove() throws InterruptedException {
                while (true) {
                    try {
                        fail.await();
                        throw new Error("Failure");
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        };
        WriteSessionCleaner sut = (WriteSessionCleaner)Deencapsulation.newInstance(WriteSessionCleaner.class, (Object[])new Object[]{referenceQueue});
        sut.start();
        Thread firstThread = (Thread)Deencapsulation.getField((Object)sut, Thread.class);
        sut.shutdown();
        fail.countDown();
        firstThread.join();
        this.awaitTermination();
    }

    @Test
    public void testDiscardsInterruptionsIfNotTerminated() throws Exception {
        ReferenceQueue<ContextWriteSession> referenceQueue = new ReferenceQueue<ContextWriteSession>(){
            private int restarts = 0;

            @Override
            public Reference<? extends ContextWriteSession> remove() throws InterruptedException {
                ++this.restarts;
                if (this.restarts == 1) {
                    throw new InterruptedException("Failure");
                }
                return super.remove();
            }
        };
        WriteSessionCleaner.launch((ReferenceQueue)referenceQueue);
        this.awaitStartUp();
        WriteSessionCleaner.terminate();
        this.awaitTermination();
    }

    private void awaitTermination() {
        while (WriteSessionCleaner.isActive()) {
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void awaitStartUp() {
        while (!WriteSessionCleaner.isActive()) {
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

