/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application;

import mockit.Expectations;
import mockit.Injectable;
import mockit.Tested;
import mockit.integration.junit4.JMockit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ldp4j.application.ContextWriteSessionState;
import org.ldp4j.application.ContextWriteSessionStateListener;
import org.ldp4j.application.session.SessionTerminationException;
import org.ldp4j.application.session.WriteSession;

@RunWith(value=JMockit.class)
public class ContextWriteSessionStateTest {
    @Injectable
    private WriteSession delegate;
    @Injectable
    private ContextWriteSessionStateListener listener;
    @Tested
    private ContextWriteSessionState sut;

    @Test
    public void testClose$circuitBreak() throws Exception {
        new Expectations(){
            {
                ContextWriteSessionStateTest.this.delegate.close();
                this.times = 1;
                ContextWriteSessionStateTest.this.listener.onDispose(ContextWriteSessionStateTest.this.sut);
                this.times = 1;
            }
        };
        this.sut.close();
        this.sut.close();
    }

    @Test
    public void testDispose$happyPath() throws Exception {
        new Expectations(){
            {
                ContextWriteSessionStateTest.this.delegate.close();
                this.times = 1;
                ContextWriteSessionStateTest.this.listener.onDispose(ContextWriteSessionStateTest.this.sut);
                this.times = 1;
            }
        };
        this.sut.dispose();
    }

    @Test
    public void testDispose$failurePath() throws Exception {
        new Expectations(){
            {
                ContextWriteSessionStateTest.this.listener.onDispose(ContextWriteSessionStateTest.this.sut);
                this.times = 1;
                ContextWriteSessionStateTest.this.delegate.close();
                this.result = new SessionTerminationException("Failure");
            }
        };
        this.sut.dispose();
    }

    @Test
    public void testVerifyExecutability$breakIfCompleted() throws Exception {
        new Expectations(){
            {
                ContextWriteSessionStateTest.this.delegate.saveChanges();
                this.times = 1;
            }
        };
        this.sut.saveChanges();
        try {
            this.sut.saveChanges();
            Assert.fail((String)"Should break circuit if already completed");
        }
        catch (IllegalStateException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"Session has already been completed"));
        }
    }

    @Test
    public void testVerifyExecutability$breakIfDisposed() throws Exception {
        new Expectations(){
            {
                ContextWriteSessionStateTest.this.listener.onDispose(ContextWriteSessionStateTest.this.sut);
                this.times = 1;
                ContextWriteSessionStateTest.this.delegate.close();
                this.times = 1;
            }
        };
        this.sut.close();
        try {
            this.sut.saveChanges();
            Assert.fail((String)"Should break circuit if already disposed");
        }
        catch (IllegalStateException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"Session has already been disposed"));
        }
    }

    @Test
    public void testVerifyExecutability$allowDisposalAfterCompletion() throws Exception {
        new Expectations(){
            {
                ContextWriteSessionStateTest.this.delegate.saveChanges();
                this.times = 1;
                ContextWriteSessionStateTest.this.listener.onDispose(ContextWriteSessionStateTest.this.sut);
                this.times = 1;
                ContextWriteSessionStateTest.this.delegate.close();
                this.times = 1;
            }
        };
        this.sut.saveChanges();
        this.sut.close();
    }
}

