/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.session;

import java.net.URI;
import java.util.Objects;
import org.ldp4j.application.session.ReadSession;
import org.ldp4j.application.session.ResourceSnapshot;
import org.ldp4j.application.spi.ResourceSnapshotResolver;
import org.ldp4j.application.spi.RuntimeDelegate;

public final class SnapshotResolver {
    private final ResourceSnapshotResolver resolver;

    private SnapshotResolver(ResourceSnapshotResolver resolver) {
        this.resolver = resolver;
    }

    public URI toURI(ResourceSnapshot snapshot) {
        return this.resolver.resolve(snapshot);
    }

    public ResourceSnapshot fromURI(URI endpoint) {
        return this.resolver.resolve(endpoint);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ReadSession session;
        private URI canonicalBase;

        private Builder() {
        }

        public Builder withCanonicalBase(URI base) {
            this.canonicalBase = base;
            return this;
        }

        public Builder withReadSession(ReadSession session) {
            this.session = session;
            return this;
        }

        public SnapshotResolver build() {
            return new SnapshotResolver(RuntimeDelegate.getInstance().createResourceResolver(this.getCanonicalBase(), Objects.requireNonNull(this.session, "Session cannot be null")));
        }

        private URI getCanonicalBase() {
            Objects.requireNonNull(this.canonicalBase, "Canonical base cannot be null");
            if (this.canonicalBase.isOpaque()) {
                throw new IllegalArgumentException("Canonical base '" + this.canonicalBase + "' is not hierarchical");
            }
            if (!this.canonicalBase.isAbsolute()) {
                throw new IllegalArgumentException("Canonical base '" + this.canonicalBase + "' is not absolute");
            }
            return this.canonicalBase;
        }
    }
}

