/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.data;

import com.google.common.base.Objects;
import java.io.Serializable;
import org.ldp4j.application.data.Name;
import org.ldp4j.application.data.NameVisitor;

final class ImmutableName<T extends Serializable>
implements Name<T> {
    private static final long serialVersionUID = -9131252943262008686L;
    private final T id;

    private ImmutableName(T id) {
        this.id = id;
    }

    @Override
    public T id() {
        return this.id;
    }

    @Override
    public void accept(NameVisitor visitor) {
        visitor.visit(this.id);
    }

    public String toString() {
        return this.id().toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id()});
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof ImmutableName) {
            result = Objects.equal(this.id, ((ImmutableName)obj).id);
        }
        return result;
    }

    public static <T extends Serializable> Name<T> newGlobalName(T id) {
        return new ImmutableName<T>(id);
    }

    public static <T extends Serializable> Name<T> newLocalName(T id) {
        return new ImmutableName<T>(id);
    }
}

