/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.data;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.ldp4j.application.data.DataSet;
import org.ldp4j.application.data.Individual;
import org.ldp4j.application.data.MutableDataSet;
import org.ldp4j.application.data.Property;
import org.ldp4j.application.data.PropertyCollection;
import org.ldp4j.application.data.Value;
import org.ldp4j.application.data.ValueVisitor;

abstract class AbstractMutableIndividual<T extends Serializable, S extends Individual<T, S>>
implements Individual<T, S> {
    private final T id;
    private final PropertyCollection properties;
    private final MutableDataSet dataSet;

    AbstractMutableIndividual(T id, MutableDataSet dataSet) {
        Preconditions.checkNotNull(id, (Object)"Id cannot be null");
        Preconditions.checkNotNull((Object)dataSet, (Object)"Dataset cannot be null");
        this.id = id;
        this.dataSet = dataSet;
        this.properties = new PropertyCollection(this, dataSet);
    }

    final void addPropertyValue(URI propertyId, Value value) {
        this.properties.addValue(propertyId, value);
    }

    final void removePropertyValue(URI propertyId, Value value) {
        this.properties.removeValue(propertyId, value);
    }

    @Override
    public final DataSet dataSet() {
        return this.dataSet;
    }

    @Override
    public final T id() {
        return this.id;
    }

    @Override
    public final int numberOfProperties() {
        return this.properties.size();
    }

    @Override
    public final boolean hasProperties() {
        return !this.properties.isEmpty();
    }

    @Override
    public final Collection<Property> properties() {
        return this.properties.properties();
    }

    @Override
    public final boolean hasProperty(URI propertyId) {
        return this.properties.hasProperty(propertyId);
    }

    @Override
    public final Property property(URI propertyId) {
        return this.properties.property(propertyId);
    }

    @Override
    public final Set<URI> propertyIds() {
        return this.properties.propertyIds();
    }

    @Override
    public final void accept(ValueVisitor visitor) {
        visitor.visitIndividual(this);
    }

    @Override
    public final Iterator<Property> iterator() {
        return this.properties().iterator();
    }
}

