/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.vocabulary;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.ldp4j.application.vocabulary.AbstractImmutableVocabulary;
import org.ldp4j.application.vocabulary.CannotAdaptClassesException;
import org.ldp4j.application.vocabulary.ImmutableTerm;
import org.ldp4j.application.vocabulary.Term;

public class ImmutableTermTest {
    private ImmutableTerm term() {
        V v = new V();
        ImmutableTerm term = new ImmutableTerm((AbstractImmutableVocabulary)v, "term");
        return term;
    }

    @Test
    public void testEqual$same() throws Exception {
        V v = new V();
        ImmutableTerm term = new ImmutableTerm((AbstractImmutableVocabulary)v, "term");
        MatcherAssert.assertThat((Object)term, (Matcher)Matchers.equalTo((Object)term));
    }

    @Test
    public void testEqual$notSame() throws Exception {
        V v = new V();
        ImmutableTerm term1 = new ImmutableTerm((AbstractImmutableVocabulary)v, "termA");
        V v2 = new V();
        ImmutableTerm term2 = new ImmutableTerm((AbstractImmutableVocabulary)v2, "termA");
        MatcherAssert.assertThat((Object)term1, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)term2)));
    }

    @Test
    public void testHashCode$isCustom() throws Exception {
        ImmutableTerm term = this.term();
        MatcherAssert.assertThat((Object)term.hashCode(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)System.identityHashCode(term))));
    }

    @Test
    public void testHashCode$notSame() throws Exception {
        V v = new V();
        ImmutableTerm term1 = new ImmutableTerm((AbstractImmutableVocabulary)v, "termA");
        V v2 = new V();
        ImmutableTerm term2 = new ImmutableTerm((AbstractImmutableVocabulary)v2, "termA");
        MatcherAssert.assertThat((Object)term1.hashCode(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)term2.hashCode())));
    }

    @Test
    public void testAs$notSupported() throws Exception {
        try {
            this.term().as(Double.class);
            Assert.fail((String)"Should not cast to Double");
        }
        catch (UnsupportedOperationException e) {
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(CannotAdaptClassesException.class));
        }
    }

    @Test
    public void testCompareTo$differentInstancesSameVocabulary() throws Exception {
        V v = new V();
        ImmutableTerm term1 = new ImmutableTerm((AbstractImmutableVocabulary)v, "termA");
        V v2 = new V();
        ImmutableTerm term2 = new ImmutableTerm((AbstractImmutableVocabulary)v2, "termA");
        try {
            term1.compareTo((Term)term2);
            Assert.fail((String)"Should not be able to compare between different instances of the same vocabulary");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
    }

    @Test
    public void testCompareTo$differentVocabularies() throws Exception {
        V v = new V();
        ImmutableTerm term1 = new ImmutableTerm((AbstractImmutableVocabulary)v, "termA");
        class VV
        extends V {
            private static final long serialVersionUID = 6590572386564141355L;

            VV() {
            }
        }
        VV v2 = new VV();
        ImmutableTerm term2 = new ImmutableTerm((AbstractImmutableVocabulary)v2, "termA");
        try {
            term1.compareTo((Term)term2);
            Assert.fail((String)"Should not be able to compare between different vocabularies");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
    }

    @Test
    public void testCompareTo$sameVocabulary() throws Exception {
        V v = new V();
        ImmutableTerm term1 = new ImmutableTerm((AbstractImmutableVocabulary)v, "termA");
        ImmutableTerm term2 = new ImmutableTerm((AbstractImmutableVocabulary)v, "termB");
        MatcherAssert.assertThat((Object)term1.compareTo((Term)term2), (Matcher)Matchers.not((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0))));
        MatcherAssert.assertThat((Object)term2.compareTo((Term)term1), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)term1.compareTo((Term)term1), (Matcher)Matchers.equalTo((Object)0));
    }

    @Test
    public void testClone() throws Exception {
        try {
            this.term().clone();
            Assert.fail((String)"Clone should not be supported");
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
    }

    static class V
    extends AbstractImmutableVocabulary<ImmutableTerm> {
        private static final long serialVersionUID = 6320487110172330521L;

        V() {
            super(ImmutableTerm.class, "namespace", "prefix");
        }
    }
}

