/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.vocabulary;

import java.lang.reflect.Method;
import java.net.URI;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.ldp4j.application.vocabulary.AdapterMethodValidator;

public abstract class AbstractAdapterMethodValidatorTest {
    private Method getMethod(Class<?> target, Class<?> ... classes) throws NoSuchMethodException {
        return target.getDeclaredMethod("adaptTo", classes);
    }

    protected abstract AdapterMethodValidator sut();

    @Test
    public void testIsValid() throws Exception {
        MatcherAssert.assertThat((Object)this.sut().isValid(this.getMethod(StaticPublic.class, String.class)), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void testIsValid$invalid$invalidName() throws Exception {
        MatcherAssert.assertThat((Object)this.sut().isValid(this.getClass().getDeclaredMethod("sut", new Class[0])), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void testIsValid$invalid$staticPrivate() throws Exception {
        MatcherAssert.assertThat((Object)this.sut().isValid(this.getMethod(StaticPrivate.class, String.class)), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void testIsValid$invalid$staticProtected() throws Exception {
        MatcherAssert.assertThat((Object)this.sut().isValid(this.getMethod(StaticProtected.class, String.class)), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void testIsValid$invalid$staticPackagePrivate() throws Exception {
        MatcherAssert.assertThat((Object)this.sut().isValid(this.getMethod(StaticPackagePrivate.class, String.class)), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void testIsValid$invalid$private() throws Exception {
        MatcherAssert.assertThat((Object)this.sut().isValid(this.getMethod(Private.class, String.class)), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void testIsValid$invalid$protected() throws Exception {
        MatcherAssert.assertThat((Object)this.sut().isValid(this.getMethod(Protected.class, String.class)), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void testIsValid$invalid$packagePrivate() throws Exception {
        MatcherAssert.assertThat((Object)this.sut().isValid(this.getMethod(PackagePrivate.class, String.class)), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void testIsValid$invalid$badReturn() throws Exception {
        MatcherAssert.assertThat((Object)this.sut().isValid(this.getMethod(BadReturn.class, String.class)), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void testIsValid$invalid$badParameter() throws Exception {
        MatcherAssert.assertThat((Object)this.sut().isValid(this.getMethod(BadParameter.class, URI.class)), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void testIsValid$invalid$noReturn() throws Exception {
        MatcherAssert.assertThat((Object)this.sut().isValid(this.getMethod(NoReturn.class, String.class)), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void testIsValid$invalid$noParameter() throws Exception {
        MatcherAssert.assertThat((Object)this.sut().isValid(this.getMethod(NoParameter.class, new Class[0])), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void testGetTargetClass() throws Exception {
        MatcherAssert.assertThat((Object)this.sut().getTargetClass(), (Matcher)Matchers.sameInstance(String.class));
    }

    private static class NoParameter {
        private NoParameter() {
        }

        public URI adaptTo() {
            return null;
        }
    }

    private static class NoReturn {
        private NoReturn() {
        }

        public void adaptTo(String string) {
        }
    }

    private static class BadParameter {
        private BadParameter() {
        }

        public URI adaptTo(URI uri) {
            return null;
        }
    }

    private static class BadReturn {
        private BadReturn() {
        }

        public String adaptTo(String string) {
            return null;
        }
    }

    private static class PackagePrivate {
        private PackagePrivate() {
        }

        URI adaptTo(String string) {
            return null;
        }
    }

    private static class Protected {
        private Protected() {
        }

        protected URI adaptTo(String string) {
            return null;
        }
    }

    private static class Private {
        private Private() {
        }

        private URI adaptTo(String string) {
            return null;
        }
    }

    private static class StaticPackagePrivate {
        private StaticPackagePrivate() {
        }

        static URI adaptTo(String string) {
            return null;
        }
    }

    private static class StaticProtected {
        private StaticProtected() {
        }

        protected static URI adaptTo(String string) {
            return null;
        }
    }

    private static class StaticPrivate {
        private StaticPrivate() {
        }

        private static URI adaptTo(String string) {
            return null;
        }
    }

    private static class StaticPublic {
        private StaticPublic() {
        }

        public static URI adaptTo(String string) {
            return null;
        }
    }
}

