/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.data;

import com.google.common.base.MoreObjects;
import java.net.URI;
import java.util.Objects;
import org.joda.time.Duration;
import org.ldp4j.application.data.DurationLiteral;
import org.ldp4j.application.data.LanguageLiteral;
import org.ldp4j.application.data.LiteralVisitor;
import org.ldp4j.application.data.TypedLiteral;
import org.ldp4j.application.data.ValueVisitor;

final class ImmutableDurationLiteral
implements DurationLiteral {
    private static final long serialVersionUID = -7312919003663624256L;
    private final Duration duration;
    private final URI dataType;

    ImmutableDurationLiteral(Duration duration, URI dataType) {
        this.duration = duration;
        this.dataType = dataType;
    }

    @Override
    public void accept(ValueVisitor visitor) {
        visitor.visitLiteral(this);
    }

    @Override
    public Duration get() {
        return this.duration;
    }

    @Override
    public void accept(LiteralVisitor visitor) {
        visitor.visitTypedLiteral(this);
    }

    @Override
    public URI type() {
        return this.dataType;
    }

    public int hashCode() {
        return Objects.hash(this.duration, this.dataType);
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof TypedLiteral) {
            TypedLiteral that = (TypedLiteral)obj;
            result = Objects.equals(this.duration, that.get()) && Objects.equals(this.dataType, that.type()) && !(obj instanceof LanguageLiteral);
        }
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("duration", (Object)this.duration).add("dataType", (Object)this.dataType).toString();
    }
}

