/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.data;

import com.google.common.base.MoreObjects;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;
import org.ldp4j.application.data.DateTimeLiteral;
import org.ldp4j.application.data.LanguageLiteral;
import org.ldp4j.application.data.LiteralVisitor;
import org.ldp4j.application.data.TypedLiteral;
import org.ldp4j.application.data.ValueVisitor;

final class ImmutableDateTimeLiteral
implements DateTimeLiteral {
    private static final long serialVersionUID = 2311445959339832121L;
    private final DateTime dateTime;
    private final URI dataType;

    ImmutableDateTimeLiteral(DateTime dateTime, URI dataType) {
        this.dateTime = dateTime;
        this.dataType = dataType;
    }

    @Override
    public void accept(ValueVisitor visitor) {
        visitor.visitLiteral(this);
    }

    @Override
    public DateTime get() {
        return this.dateTime;
    }

    @Override
    public void accept(LiteralVisitor visitor) {
        visitor.visitTypedLiteral(this);
    }

    @Override
    public URI type() {
        return this.dataType;
    }

    public int hashCode() {
        return Objects.hash(this.dateTime, this.dataType);
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof TypedLiteral) {
            TypedLiteral that = (TypedLiteral)obj;
            result = Objects.equals(this.dateTime, that.get()) && Objects.equals(this.dataType, that.type()) && !(obj instanceof LanguageLiteral);
        }
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("dateTime", (Object)this.dateTime).add("dataType", (Object)this.dataType).toString();
    }
}

