/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application;

import com.google.common.base.Preconditions;
import org.ldp4j.application.ApplicationContextException;
import org.ldp4j.application.data.Individual;
import org.ldp4j.application.data.Name;
import org.ldp4j.application.ext.ResourceHandler;
import org.ldp4j.application.session.ResourceSnapshot;
import org.ldp4j.application.session.WriteSession;
import org.ldp4j.application.session.WriteSessionException;
import org.ldp4j.application.spi.RuntimeDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApplicationContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationContext.class);
    private final RuntimeDelegate delegate = RuntimeDelegate.getInstance();
    private final ThreadLocal<WriteSession> session = new ThreadLocal();

    private ApplicationContext() {
        LOGGER.info("Initialized Application Context");
    }

    private ApplicationContextException failure(Throwable cause, String fmt, Object ... args) {
        String message = String.format(fmt, args);
        if (cause != null) {
            LOGGER.error(message + ". Full stacktrace follows", cause);
        } else {
            LOGGER.error(message);
        }
        return new ApplicationContextException(message, cause);
    }

    public WriteSession createSession() throws ApplicationContextException {
        if (this.session.get() != null) {
            throw this.failure(null, "Thread already has an active session", new Object[0]);
        }
        try {
            if (this.delegate.isOffline()) {
                throw this.failure(null, "The Application Engine is off-line", new Object[0]);
            }
            return new SafeWriteSession(this.delegate.createSession());
        }
        catch (UnsupportedOperationException e) {
            throw this.failure(e, "No Application Engine is available", new Object[0]);
        }
    }

    public void disposeSession(WriteSession session) throws ApplicationContextException {
        Preconditions.checkNotNull((Object)session, (Object)"Session cannot be null");
        Preconditions.checkArgument((boolean)(session instanceof SafeWriteSession), (Object)"Unknown session");
        if (this.session.get() != session) {
            throw this.failure(null, "Session '%s' is not owned by current thread", session);
        }
        SafeWriteSession safeWriteSession = (SafeWriteSession)session;
        safeWriteSession.dispose();
    }

    public static ApplicationContext getInstance() {
        return ApplicationEngineSingleton.SINGLETON;
    }

    private final class SafeWriteSession
    implements WriteSession {
        private final WriteSession nativeSession;
        private boolean dispossed;
        private boolean completed;

        private SafeWriteSession(WriteSession session) {
            this.nativeSession = session;
        }

        private void verifyExecutability() {
            Preconditions.checkState((!this.dispossed ? 1 : 0) != 0, (Object)"Session has already been dispossed");
            Preconditions.checkState((!this.completed ? 1 : 0) != 0, (Object)"Session has already been completed");
        }

        @Override
        public <S extends ResourceSnapshot> S resolve(Class<? extends S> snapshotClass, Individual<?, ?> individual) {
            this.verifyExecutability();
            return this.nativeSession.resolve(snapshotClass, individual);
        }

        @Override
        public <S extends ResourceSnapshot> S find(Class<? extends S> snapshotClass, Name<?> id, Class<? extends ResourceHandler> handlerClass) {
            this.verifyExecutability();
            return this.nativeSession.find(snapshotClass, id, handlerClass);
        }

        @Override
        public void modify(ResourceSnapshot resource) {
            this.verifyExecutability();
            this.nativeSession.modify(resource);
        }

        @Override
        public void delete(ResourceSnapshot resource) {
            this.verifyExecutability();
            this.nativeSession.delete(resource);
        }

        @Override
        public void saveChanges() throws WriteSessionException {
            this.verifyExecutability();
            this.completed = true;
            this.nativeSession.saveChanges();
        }

        @Override
        public void discardChanges() throws WriteSessionException {
            this.verifyExecutability();
            this.completed = true;
            this.nativeSession.discardChanges();
        }

        void dispose() throws ApplicationContextException {
            if (!this.dispossed) {
                this.dispossed = true;
                ApplicationContext.this.session.remove();
                ApplicationContext.this.delegate.terminateSession(this.nativeSession);
            }
        }
    }

    private static final class ApplicationEngineSingleton {
        private static final ApplicationContext SINGLETON = new ApplicationContext();

        private ApplicationEngineSingleton() {
        }
    }
}

