/**
 * #-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=#
 *   This file is part of the LDP4j Project:
 *     http://www.ldp4j.org/
 *
 *   Center for Open Middleware
 *     http://www.centeropenmiddleware.com/
 * #-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=#
 *   Copyright (C) 2014 Center for Open Middleware.
 * #-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=#
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *             http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 * #-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=#
 *   Artifact    : org.ldp4j.framework:ldp4j-application-api:0.1.0
 *   Bundle      : ldp4j-application-api-0.1.0.jar
 * #-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=#
 */
package org.ldp4j.application.ext;

import java.util.concurrent.atomic.AtomicReference;

import org.ldp4j.application.data.constraints.Constraints;

public class InvalidContentException extends ApplicationUsageException {

	private static final long serialVersionUID = 1090034112299823594L;
	private final Constraints constraints;

	private final AtomicReference<String> id;

	public InvalidContentException(String message, Throwable cause, Constraints constraints) {
		super(message, cause);
		this.constraints = constraints;
		this.id=new AtomicReference<String>(null);
	}

	public InvalidContentException(String message, Constraints constraints) {
		this(message,null,constraints);
	}

	public InvalidContentException(Throwable cause, Constraints constraints) {
		this(null,cause,constraints);
	}

	public Constraints getConstraints() {
		return constraints;
	}

	public final void setConstraintsId(String id) {
		this.id.set(id);
	}

	public final String getConstraintsId() {
		return this.id.get();
	}

}