/**
 * #-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=#
 *   This file is part of the LDP4j Project:
 *     http://www.ldp4j.org/
 *
 *   Center for Open Middleware
 *     http://www.centeropenmiddleware.com/
 * #-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=#
 *   Copyright (C) 2014 Center for Open Middleware.
 * #-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=#
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *             http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 * #-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=#
 *   Artifact    : org.ldp4j.framework:ldp4j-application-api:0.1.0
 *   Bundle      : ldp4j-application-api-0.1.0.jar
 * #-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=#
 */
package org.ldp4j.application.ext;

import org.ldp4j.application.session.WriteSession;
import org.ldp4j.application.setup.Bootstrap;
import org.ldp4j.application.setup.Environment;

/**
 * The entry point for an LDP4j Application. This class provides the means for
 * controlling the life-cycle of the application: the bootstrapping of the
 * application and the application termination.
 */
public abstract class Application<T extends Configuration> {

	/**
	 * Returns the {@link Class} of the configuration class type parameter.
	 *
	 * @return the configuration class
	 * @see Generics#getTypeParameter(Class, Class)
	 */
	public final Class<T> getConfigurationClass() {
		return Generics.getTypeParameter(getClass(), Configuration.class);
	}

	/**
	 * Returns the name of the application.
	 *
	 * @return the application's name
	 */
	public String getName() {
		return getClass().getSimpleName();
	}

	public abstract void setup(Environment environment, Bootstrap<T> bootstrap) throws ApplicationSetupException;

	public abstract void initialize(WriteSession session) throws ApplicationInitializationException;

	public abstract void shutdown() throws ApplicationShutdownException;

}