/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.server.LimitEnforcementMode;

class UserInfoEntry {
    private final long id;
    private final String email;
    @JsonIgnore
    private final byte[] passwordHash;
    private final String addonToken;
    @Nullable
    private final String apiKey;
    private final Long userDictCacheSize;
    private final Long requestsPerDay;
    private final LimitEnforcementMode limitEnforcement;
    @Nullable
    private final Long managedAccounts;
    private final Date premiumFrom;
    private final Date premiumTo;
    @Nullable
    private final Long userGroup;
    @Nullable
    private final UUID groupId;
    @Nullable
    private final String groupRole;
    @Nullable
    private final String defaultDictionary;
    private final boolean opt_in_3rd_party_ai_grammar_checker;
    private final boolean opt_in_3rd_party_ai_paraphraser;

    UserInfoEntry(long id, String email, @Nullable Long userDictCacheSize, @Nullable Long requestsPerDay, @Nullable Integer limitEnforcement, @Nullable Long managedAccounts, @Nullable String passwordHash, @Nullable java.sql.Date premiumFrom, @Nullable java.sql.Date premiumTo, String addonToken, String apiKey, @Nullable Long userGroup, @Nullable UUID groupId, @Nullable String groupRole) {
        this(id, email, userDictCacheSize, requestsPerDay, limitEnforcement, managedAccounts, passwordHash, premiumFrom, premiumTo, addonToken, apiKey, userGroup, groupId, groupRole, null, false, false);
    }

    UserInfoEntry(long id, String email, @Nullable Long userDictCacheSize, @Nullable Long requestsPerDay, @Nullable Integer limitEnforcement, @Nullable Long managedAccounts, @Nullable String passwordHash, @Nullable java.sql.Date premiumFrom, @Nullable java.sql.Date premiumTo, String addonToken, @Nullable String apiKey, @Nullable Long userGroup, @Nullable UUID groupId, @Nullable String groupRole, @Nullable String defaultDictionary, boolean opt_in_3rd_party_ai_grammar_checker, boolean opt_in_3rd_party_ai_paraphraser) {
        this.id = id;
        this.email = email;
        this.addonToken = addonToken;
        this.apiKey = apiKey;
        this.userDictCacheSize = userDictCacheSize;
        this.requestsPerDay = requestsPerDay;
        this.managedAccounts = managedAccounts;
        this.limitEnforcement = LimitEnforcementMode.parse(limitEnforcement);
        this.passwordHash = passwordHash != null ? passwordHash.getBytes(StandardCharsets.UTF_8) : null;
        this.premiumFrom = premiumFrom;
        this.premiumTo = premiumTo;
        this.userGroup = userGroup;
        this.groupId = groupId;
        this.groupRole = groupRole;
        this.defaultDictionary = defaultDictionary;
        this.opt_in_3rd_party_ai_grammar_checker = opt_in_3rd_party_ai_grammar_checker;
        this.opt_in_3rd_party_ai_paraphraser = opt_in_3rd_party_ai_paraphraser;
    }

    @Nullable
    Date getPremiumFrom() {
        return this.premiumFrom;
    }

    @Nullable
    Date getPremiumTo() {
        return this.premiumTo;
    }

    @Nullable
    Long getUserDictCacheSize() {
        return this.userDictCacheSize;
    }

    long getUserId() {
        return this.id;
    }

    String getEmail() {
        return this.email;
    }

    @Nullable
    public Long getRequestsPerDay() {
        return this.requestsPerDay;
    }

    @NotNull
    public LimitEnforcementMode getLimitEnforcement() {
        return this.limitEnforcement;
    }

    @Nullable
    public byte[] getPasswordHash() {
        return this.passwordHash;
    }

    public boolean hasPremium() {
        Calendar startOfToday = Calendar.getInstance();
        startOfToday.set(11, 0);
        startOfToday.set(12, 0);
        startOfToday.set(13, 0);
        startOfToday.set(14, 0);
        return this.premiumFrom != null && (this.premiumTo == null || this.premiumTo.compareTo(startOfToday.getTime()) >= 0);
    }

    public String getAddonToken() {
        return this.addonToken;
    }

    @Nullable
    public String getApiKey() {
        return this.apiKey;
    }

    @Nullable
    public Long getManagedAccounts() {
        return this.managedAccounts;
    }

    @Nullable
    public Long getUserGroup() {
        return this.userGroup;
    }

    public UUID getGroupId() {
        return this.groupId;
    }

    public String getGroupRole() {
        return this.groupRole;
    }

    @Nullable
    @Generated
    public String getDefaultDictionary() {
        return this.defaultDictionary;
    }

    @Generated
    public boolean isOpt_in_3rd_party_ai_grammar_checker() {
        return this.opt_in_3rd_party_ai_grammar_checker;
    }

    @Generated
    public boolean isOpt_in_3rd_party_ai_paraphraser() {
        return this.opt_in_3rd_party_ai_paraphraser;
    }
}

