/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.ibatis.datasource.pooled.PooledDataSource;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.languagetool.Language;
import org.languagetool.Premium;
import org.languagetool.rules.Rule;
import org.languagetool.server.BadRequestException;
import org.languagetool.server.DatabaseAccess;
import org.languagetool.server.DatabaseLogger;
import org.languagetool.server.DictGroupEntry;
import org.languagetool.server.ExtendedUserInfo;
import org.languagetool.server.HTTPServerConfig;
import org.languagetool.server.UserInfoEntry;
import org.languagetool.server.UserLimits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DatabaseAccessOpenSource
extends DatabaseAccess {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseAccessOpenSource.class);
    private static final String NON_PREMIUM_MSG = "This server does not support username/password";
    private final Cache<String, Long> dbLoggingCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).maximumSize(5000L).build();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DatabaseAccessOpenSource(HTTPServerConfig config) {
        super(config);
        if (config.getDatabaseDriver() != null) {
            try {
                logger.info("Setting up database access, URL " + config.getDatabaseUrl() + ", driver: " + config.getDatabaseDriver() + ", user: " + config.getDatabaseUsername());
                InputStream inputStream = Resources.getResourceAsStream((String)"org/languagetool/server/mybatis-config.xml");
                Properties properties = new Properties();
                properties.setProperty("driver", config.getDatabaseDriver());
                properties.setProperty("url", config.getDatabaseUrl());
                properties.setProperty("username", config.getDatabaseUsername());
                properties.setProperty("password", config.getDatabasePassword());
                properties.setProperty("premium", Premium.isPremiumVersion() ? "Premium" : "OpenSource");
                properties.setProperty("timeout", String.valueOf(config.getDbTimeoutSeconds()));
                this.sqlSessionFactory = new SqlSessionFactoryBuilder().build(inputStream, properties);
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    if (this.sqlSessionFactory != null) {
                        ((PooledDataSource)this.sqlSessionFactory.getConfiguration().getEnvironment().getDataSource()).forceCloseAll();
                    }
                }));
                DatabaseLogger.init(this.sqlSessionFactory);
                if (config.getDatabaseLogging()) return;
                logger.info("dbLogging not set to true, turning off logging");
                DatabaseLogger.getInstance().disableLogging();
                return;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            logger.info("Not setting up database access, dbDriver is not configured");
        }
    }

    @Override
    void invalidateCaches() {
    }

    @Override
    boolean addWord(String word, Long userId, String groupName) {
        return this.addWord(word, userId);
    }

    @Override
    boolean deleteWord(String word, Long userId, String groupName) {
        return this.deleteWord(word, userId);
    }

    @Override
    boolean deleteWordBatch(List<String> words, Long userId, String groupName) {
        boolean deleted = false;
        for (String word : words) {
            if (!this.deleteWord(word, userId)) continue;
            deleted = true;
        }
        return deleted;
    }

    @Override
    void addWordBatch(List<String> words, Long userId, String groupName) {
        words.forEach(w -> this.addWord((String)w, userId));
    }

    @Override
    UserInfoEntry getUserInfoWithPassword(String username, String password) {
        throw new NotImplementedException(NON_PREMIUM_MSG);
    }

    @Override
    ExtendedUserInfo getExtendedUserInfo(String user) {
        throw new NotImplementedException(NON_PREMIUM_MSG);
    }

    @Override
    ExtendedUserInfo getExtendedUserInfo(long userId) {
        throw new NotImplementedException(NON_PREMIUM_MSG);
    }

    @Override
    UserInfoEntry getUserInfoWithApiKey(String username, String apiKey) {
        Long userId = this.getUserId(username, apiKey);
        UserInfoEntry user = new UserInfoEntry(userId, username, null, null, null, null, null, null, null, null, apiKey, null);
        return user;
    }

    @Override
    UserInfoEntry getUserInfoWithAddonToken(String username, String apiKey) {
        throw new NotImplementedException(NON_PREMIUM_MSG);
    }

    @Override
    void invalidateUserInfoCache(String user) {
        throw new NotImplementedException(NON_PREMIUM_MSG);
    }

    @Override
    Long getUserRequestCount(Long userId) {
        return null;
    }

    List<String> getWords(Long userId, int offset, int limit) {
        if (this.sqlSessionFactory == null) {
            return new ArrayList<String>();
        }
        try (SqlSession session = this.sqlSessionFactory.openSession(true);){
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("userId", userId);
            List list = session.selectList("org.languagetool.server.UserDictMapper.selectWordList", map, new RowBounds(offset, limit));
            return list;
        }
    }

    boolean addWord(String word, Long userId) {
        this.validateWord(word);
        if (this.sqlSessionFactory == null) {
            return false;
        }
        try (SqlSession session = this.sqlSessionFactory.openSession(true);){
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("word", word);
            map.put("userId", userId);
            List existingWords = session.selectList("org.languagetool.server.UserDictMapper.selectWord", map);
            if (existingWords.size() >= 1) {
                logger.info("Did not add '" + word + "' for user " + userId + " to list of ignored words, already exists");
                boolean bl = false;
                return bl;
            }
            Date now = new Date();
            map.put("created_at", now);
            map.put("updated_at", now);
            int affectedRows = session.insert("org.languagetool.server.UserDictMapper.addWord", map);
            logger.info("Added '" + word + "' for user " + userId + " to list of ignored words, affectedRows: " + affectedRows);
            boolean bl = affectedRows == 1;
            return bl;
        }
    }

    Long getUserId(String username, String apiKey) {
        if (username == null || username.trim().isEmpty()) {
            throw new IllegalArgumentException("username must be set");
        }
        if (apiKey == null || apiKey.trim().isEmpty()) {
            throw new IllegalArgumentException("apiKey must be set");
        }
        if (this.sqlSessionFactory == null) {
            throw new IllegalStateException("This is the endpoint for the basic version of LanguageTool. When using 'username' and 'apiKey' to access the premium version, use api.languagetoolplus.com instead.");
        }
        try {
            Long value = (Long)this.dbLoggingCache.get((Object)String.format("user_%s_%s", username, apiKey), () -> {
                try (SqlSession session = this.sqlSessionFactory.openSession();){
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("username", username);
                    map.put("apiKey", apiKey);
                    Long id = (Long)session.selectOne("org.languagetool.server.UserDictMapper.getUserIdByApiKey", map);
                    if (id == null) {
                        Long l = -1L;
                        return l;
                    }
                    Long l = id;
                    return l;
                }
            });
            if (value == -1L) {
                throw new IllegalArgumentException("No user found for given username '" + username + "' and given api key");
            }
            return value;
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Could not fetch given user '" + username + "' from cache", e);
        }
    }

    boolean deleteWord(String word, Long userId) {
        if (this.sqlSessionFactory == null) {
            return false;
        }
        try (SqlSession session = this.sqlSessionFactory.openSession(true);){
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("word", word);
            map.put("userId", userId);
            int count = session.delete("org.languagetool.server.UserDictMapper.selectWord", map);
            if (count == 0) {
                logger.info("Did not delete '" + word + "' for user " + userId + " from list of ignored words, does not exist");
                boolean bl = false;
                return bl;
            }
            int affectedRows = session.delete("org.languagetool.server.UserDictMapper.deleteWord", map);
            logger.info("Deleted '" + word + "' for user " + userId + " from list of ignored words, affectedRows: " + affectedRows);
            boolean bl = affectedRows >= 1;
            return bl;
        }
    }

    @Override
    Long getOrCreateServerId() {
        return null;
    }

    @Override
    Long getOrCreateClientId(String client) {
        if (this.sqlSessionFactory == null || client == null) {
            return null;
        }
        try {
            Long id = (Long)this.dbLoggingCache.get((Object)("client_" + client), () -> {
                try (SqlSession session = this.sqlSessionFactory.openSession(true);){
                    HashMap<String, String> parameters = new HashMap<String, String>();
                    parameters.put("name", client);
                    List result = session.selectList("org.languagetool.server.LogMapper.findClient", parameters);
                    if (result.size() > 0) {
                        Long l = (Long)result.get(0);
                        return l;
                    }
                    session.insert("org.languagetool.server.LogMapper.newClient", parameters);
                    Object value = parameters.get("id");
                    if (value == null) {
                        Long l = -1L;
                        return l;
                    }
                    Long l = (Long)value;
                    return l;
                }
                catch (PersistenceException e) {
                    logger.warn("Error: Could not get/register id for this client: " + client, (Throwable)e);
                    return -1L;
                }
            });
            if (id == -1L) {
                return null;
            }
            return id;
        }
        catch (ExecutionException e) {
            logger.warn("Failure in getOrCreateClientId with client '" + client + "': ", (Throwable)e);
            return null;
        }
    }

    @Override
    List<DictGroupEntry> getDictGroups(Long userId) {
        return Collections.emptyList();
    }

    @Override
    Long getOrCreateDictGroup(Long userId, String groupName) {
        throw new NotImplementedException(NON_PREMIUM_MSG);
    }

    private void validateWord(String word) {
        if (word == null || word.trim().isEmpty()) {
            throw new BadRequestException("Invalid word, cannot be empty or whitespace only");
        }
        if (word.matches(".*\\s.*")) {
            throw new BadRequestException("Invalid word, you can only words that don't contain spaces: '" + word + "'");
        }
    }

    @Override
    public void createAndFillTestTables(boolean mysql, List<String> skipStatements) {
        try (SqlSession session = this.sqlSessionFactory.openSession(true);){
            String[] statements;
            System.out.println("Setting up tables and adding test user...");
            for (String statement : statements = new String[]{"org.languagetool.server.UserDictMapper.createUserTable", "org.languagetool.server.UserDictMapper.createIgnoreWordTable"}) {
                if (skipStatements.contains(statement)) continue;
                if (mysql) {
                    session.insert(statement + "MySQL");
                    continue;
                }
                session.insert(statement);
            }
            session.insert("org.languagetool.server.UserDictMapper.createTestUser1");
            session.insert("org.languagetool.server.UserDictMapper.createTestUser2");
        }
    }

    @Override
    public void deleteTestTables() {
        try (SqlSession session = this.sqlSessionFactory.openSession(true);){
            System.out.println("Deleting tables...");
            session.delete("org.languagetool.server.UserDictMapper.deleteUsersTable");
            session.delete("org.languagetool.server.UserDictMapper.deleteIgnoreWordsTable");
        }
    }

    @Override
    public List<String> getWords(UserLimits limits, List<String> groups, int offset, int limit) {
        return this.getWords(limits.getPremiumUid(), offset, limit);
    }

    @Override
    public List<Rule> getRules(UserLimits limits, Language lang, List<String> groups) {
        return Collections.emptyList();
    }
}

