/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.server.LimitEnforcementMode;

class UserInfoEntry {
    private final long id;
    private final byte[] passwordHash;
    private final String addonToken;
    @Nullable
    private final String apiKey;
    private final Long userDictCacheSize;
    private final Long requestsPerDay;
    private final LimitEnforcementMode limitEnforcement;
    @Nullable
    private final Long managedAccounts;
    private final Date premiumFrom;
    private final Date premiumTo;
    @Nullable
    private final Long userGroup;

    UserInfoEntry(long id, @Nullable Long userDictCacheSize, @Nullable Long requestsPerDay, @Nullable Integer limitEnforcement, @Nullable Long managedAccounts, @Nullable String passwordHash, @Nullable java.sql.Date premiumFrom, @Nullable java.sql.Date premiumTo, String addonToken, String apiKey, @Nullable Long userGroup) {
        this.id = id;
        this.addonToken = addonToken;
        this.apiKey = apiKey;
        this.userDictCacheSize = userDictCacheSize;
        this.requestsPerDay = requestsPerDay;
        this.managedAccounts = managedAccounts;
        this.limitEnforcement = LimitEnforcementMode.parse(limitEnforcement);
        this.passwordHash = passwordHash != null ? passwordHash.getBytes(StandardCharsets.UTF_8) : null;
        this.premiumFrom = premiumFrom;
        this.premiumTo = premiumTo;
        this.userGroup = userGroup;
    }

    @Nullable
    Date getPremiumFrom() {
        return this.premiumFrom;
    }

    @Nullable
    Date getPremiumTo() {
        return this.premiumTo;
    }

    @Nullable
    Long getUserDictCacheSize() {
        return this.userDictCacheSize;
    }

    long getUserId() {
        return this.id;
    }

    @Nullable
    public Long getRequestsPerDay() {
        return this.requestsPerDay;
    }

    @NotNull
    public LimitEnforcementMode getLimitEnforcement() {
        return this.limitEnforcement;
    }

    @Nullable
    public byte[] getPasswordHash() {
        return this.passwordHash;
    }

    public boolean hasPremium() {
        Calendar startOfToday = Calendar.getInstance();
        startOfToday.set(11, 0);
        startOfToday.set(12, 0);
        startOfToday.set(13, 0);
        startOfToday.set(14, 0);
        return this.premiumFrom != null && (this.premiumTo == null || this.premiumTo.compareTo(startOfToday.getTime()) >= 0);
    }

    public String getAddonToken() {
        return this.addonToken;
    }

    @Nullable
    public String getApiKey() {
        return this.apiKey;
    }

    @Nullable
    public Long getManagedAccounts() {
        return this.managedAccounts;
    }

    @Nullable
    public Long getUserGroup() {
        return this.userGroup;
    }
}

